/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntriesCache {
    private static final String SVN_THIS_DIR = "svn:this_dir";
    private static final String EMPTY_STRING = "";
    private static final String DELIMITER = "\f";
    static String[] entryFileAttributes = new String[]{"name", "kind", "revision", "url", "repos", "schedule", "text-time", "checksum", "committed-date", "committed-rev", "last-author", "has-props", "has-prop-mods", "cachable-props", "present-props", "prop-reject-file", "conflict-old", "conflict-new", "conflict-wrk", "copied", "copyfrom-url", "copyfrom-rev", "deleted", "absent", "incomplete", "uuid", "lock-token", "lock-owner", "lock-comment", "lock-creation-date"};
    private static final Set<String> BOOLEAN_ATTRIBUTES = new HashSet<String>();
    private Entries entries;
    private static EntriesCache instance;

    private EntriesCache() {
    }

    static EntriesCache getInstance() {
        if (instance == null) {
            instance = new EntriesCache();
        }
        return instance;
    }

    Map<String, String> getFileAttributes(File file) throws IOException, SAXException {
        File entriesFile = SvnWcUtils.getEntriesFile(file);
        if (entriesFile == null) {
            return null;
        }
        return this.getFileAttributes(entriesFile, file);
    }

    private synchronized Map<String, String> getFileAttributes(File entriesFile, File file) throws IOException, SAXException {
        EntriesFile ef = (EntriesFile)this.getEntries().get(entriesFile.getAbsolutePath());
        long lastModified = entriesFile.lastModified();
        long fileLength = entriesFile.length();
        if (ef == null || ef.ts != lastModified || ef.size != fileLength) {
            EntryAttributes ea = this.getAttributesFromEntriesFile(entriesFile);
            ef = new EntriesFile(this.getMergedAttributes(ea), lastModified, fileLength);
            this.getEntries().put(entriesFile.getAbsolutePath(), ef);
        }
        if (ef.attributes.get(file.getName()) == null) {
            Map<String, String> attributes = this.mergeThisDirAttributes(file.isDirectory(), file.getName(), ef.attributes);
        }
        return (Map)ef.attributes.get(file.isDirectory() ? SVN_THIS_DIR : file.getName());
    }

    private EntryAttributes getMergedAttributes(EntryAttributes ea) throws SAXException {
        for (String fileName : ea.keySet()) {
            boolean isDirectory = ((String)((Map)ea.get(fileName)).get("kind")).equals("dir");
            Map<String, String> attributes = this.mergeThisDirAttributes(isDirectory, fileName, ea);
            if (isDirectory) {
                attributes.put("handled", EMPTY_STRING + (((Map)ea.get(SVN_THIS_DIR)).get("deleted") == null));
                continue;
            }
            if (ea.get(fileName) != null) {
                for (Map.Entry entry : ((Map)ea.get(fileName)).entrySet()) {
                    attributes.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            attributes.put("handled", EMPTY_STRING + (ea.containsKey(fileName) && ea.get("deleted") == null));
        }
        return ea;
    }

    private Map<String, String> mergeThisDirAttributes(boolean isDirectory, String fileName, EntryAttributes ea) {
        HashMap<String, String> attributes = (HashMap<String, String>)ea.get(fileName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            ea.put(fileName, attributes);
        }
        for (Map.Entry entry : ((Map)ea.get(SVN_THIS_DIR)).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (isDirectory) {
                attributes.put(key, value);
                continue;
            }
            if (key.equals("url")) {
                if (attributes.get(key) != null) continue;
                attributes.put(key, value + "/" + fileName);
                continue;
            }
            if (!key.equals("uuid") && !key.equals("repos") && !key.equals("revision") && !key.equals("wc-version") || attributes.get(key) != null) continue;
            attributes.put(key, value);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryAttributes getAttributesFromEntriesFile(File entriesFile) throws IOException, SAXException {
        boolean isXml = false;
        BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(entriesFile), "UTF8"));
        try {
            String firstLine = fileReader.readLine();
            try {
                Integer.valueOf(firstLine);
                isXml = false;
            }
            catch (NumberFormatException ex) {
                isXml = true;
            }
            if (isXml) {
                EntryAttributes entryAttributes = this.loadAttributesFromXml(entriesFile);
                return entryAttributes;
            }
            EntryAttributes entryAttributes = this.loadAttributesFromPlainText(fileReader, entriesFile.getAbsolutePath());
            return entryAttributes;
        }
        finally {
            fileReader.close();
        }
    }

    private EntryAttributes loadAttributesFromXml(File entriesFile) throws IOException, SAXException {
        XMLReader saxReader = XMLUtil.createXMLReader();
        XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
        saxReader.setContentHandler(xmlEntriesHandler);
        saxReader.setErrorHandler(xmlEntriesHandler);
        FileInputStream inputStream = new FileInputStream(entriesFile);
        try {
            saxReader.parse(new InputSource(inputStream));
        }
        catch (SAXException ex) {
            throw ex;
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return xmlEntriesHandler.getEntryAttributes();
    }

    private EntryAttributes loadAttributesFromPlainText(BufferedReader entriesReader, String entryFilePath) throws IOException {
        EntryAttributes returnValue = new EntryAttributes();
        int attrIndex = 0;
        String entryName = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String nextLine = entriesReader.readLine();
        while (nextLine != null) {
            if (attrIndex == 0 && (entryName = nextLine).equals(EMPTY_STRING)) {
                entryName = SVN_THIS_DIR;
            }
            if (!EMPTY_STRING.equals(nextLine)) {
                if (EntriesCache.isBooleanValue(entryFileAttributes[attrIndex])) {
                    nextLine = "true";
                }
                attributes.put(entryFileAttributes[attrIndex], nextLine);
            }
            if ((nextLine = entriesReader.readLine()) != null && ++attrIndex > entryFileAttributes.length - 1) {
                ErrorManager.getDefault().log(16, "Skipping attribute from position " + attrIndex + " in entry file " + entryFilePath);
                while (nextLine != null && !DELIMITER.equals(nextLine)) {
                    nextLine = entriesReader.readLine();
                }
            }
            if (!DELIMITER.equals(nextLine)) continue;
            attributes.put("wc-version", "1.4");
            returnValue.put(entryName, attributes);
            attributes = new HashMap();
            attrIndex = 0;
            nextLine = entriesReader.readLine();
        }
        return returnValue;
    }

    private static boolean isBooleanValue(String attribute) {
        return BOOLEAN_ATTRIBUTES.contains(attribute);
    }

    private Entries getEntries() {
        if (this.entries == null) {
            this.entries = new Entries();
        }
        return this.entries;
    }

    static {
        BOOLEAN_ATTRIBUTES.add("has-props");
        BOOLEAN_ATTRIBUTES.add("has-prop-mods");
        BOOLEAN_ATTRIBUTES.add("copied");
        BOOLEAN_ATTRIBUTES.add("deleted");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends HashMap<String, EntriesFile> {
        private Entries() {
        }
    }

    private class EntriesFile {
        long ts;
        long size;
        EntryAttributes attributes;

        EntriesFile(EntryAttributes attributes, long ts, long size) {
            this.ts = ts;
            this.size = size;
            this.attributes = attributes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryAttributes
    extends HashMap<String, Map<String, String>> {
        private EntryAttributes() {
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ATTRIBUTE = "name";
        private EntryAttributes entryAttributes;

        private XmlEntriesHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < elementAttributes.getLength(); ++i) {
                    String name = elementAttributes.getQName(i);
                    String value = elementAttributes.getValue(i);
                    attributes.put(name, value);
                }
                String nameValue = (String)attributes.get(NAME_ATTRIBUTE);
                if (nameValue == null || EntriesCache.EMPTY_STRING.equals(nameValue)) {
                    nameValue = EntriesCache.SVN_THIS_DIR;
                }
                if (this.entryAttributes == null) {
                    this.entryAttributes = new EntryAttributes();
                }
                attributes.put("wc-version", "1.3");
                this.entryAttributes.put(nameValue, attributes);
            }
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public EntryAttributes getEntryAttributes() {
            return this.entryAttributes;
        }
    }
}

