/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class LocalSvnInfoImpl
implements ISVNInfo {
    private final File file;
    private final SVNUrl url;
    private final SVNUrl reposUrl;
    private final String reposUuid;
    private final SVNScheduleKind schedule;
    private final SVNRevision.Number revision;
    private final boolean isCopied;
    private final SVNUrl urlCopiedFrom;
    private final SVNRevision.Number revisionCopiedFrom;
    private final Date lastChangedDate;
    private final SVNRevision.Number lastChangedRevision;
    private final String lastCommitAuthor;
    private final Date lastDatePropsUpdate;
    private final Date lastDateTextUpdate;
    private final Date lockCreationDate;
    private final String lockOwner;
    private final String lockComment;
    private final SVNNodeKind nodeKind;
    private final File propertiesFile;
    private final File basePropertiesFile;

    public LocalSvnInfoImpl(File file, String url, String reposUrl, String reposUuid, String schedule, long revision, boolean isCopied, String urlCopiedFrom, long revisionCopiedFrom, Date lastChangedDate, long lastChangedRevision, String lastCommitAuthor, Date lastDatePropsUpdate, Date lastDateTextUpdate, Date lockCreationDate, String lockOwner, String lockComment, String nodeKind, File propertiesFile, File basePropertiesFile) {
        this.file = file;
        try {
            this.url = url != null ? new SVNUrl(url) : null;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            this.reposUrl = reposUrl != null ? new SVNUrl(reposUrl) : null;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.reposUuid = reposUuid;
        this.schedule = SVNScheduleKind.fromString((String)schedule);
        this.revision = new SVNRevision.Number(revision);
        this.isCopied = isCopied;
        try {
            this.urlCopiedFrom = isCopied && urlCopiedFrom != null ? new SVNUrl(urlCopiedFrom) : null;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.revisionCopiedFrom = isCopied ? new SVNRevision.Number(revisionCopiedFrom) : null;
        this.lastChangedDate = lastChangedDate;
        this.lastChangedRevision = new SVNRevision.Number(lastChangedRevision);
        this.lastCommitAuthor = lastCommitAuthor;
        this.lastDatePropsUpdate = lastDatePropsUpdate;
        this.lastDateTextUpdate = lastDateTextUpdate;
        this.lockCreationDate = lockCreationDate;
        this.lockOwner = lockOwner;
        this.lockComment = lockComment;
        this.nodeKind = SVNNodeKind.fromString((String)nodeKind);
        this.propertiesFile = propertiesFile;
        this.basePropertiesFile = basePropertiesFile;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public String getUuid() {
        return this.reposUuid;
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNScheduleKind getSchedule() {
        return this.schedule;
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public SVNRevision.Number getCopyRev() {
        return this.revisionCopiedFrom;
    }

    public SVNUrl getCopyUrl() {
        return this.urlCopiedFrom;
    }

    public File getFile() {
        return this.file;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Date getLastDatePropsUpdate() {
        return this.lastDatePropsUpdate;
    }

    public Date getLastDateTextUpdate() {
        return this.lastDateTextUpdate;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public Date getLockCreationDate() {
        return this.lockCreationDate;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public SVNUrl getRepository() {
        return this.reposUrl;
    }

    public String getUrlString() {
        return this.url.toString();
    }

    public File getPropertyFile() {
        return this.propertiesFile;
    }

    public File getBasePropertyFile() {
        return this.basePropertiesFile;
    }
}

