/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopyDetails {
    static final String FILE_ATTRIBUTE_VALUE = "file";
    static final String IS_HANDLED = "handled";
    private static final char SLASH_N = '\n';
    private static final char SLASH_R = '\r';
    static final String VERSION_ATTR_KEY = "wc-version";
    static final String VERSION_UNKNOWN = "";
    static final String VERSION_13 = "1.3";
    static final String VERSION_14 = "1.4";
    private final File file;
    private final Map<String, String> attributes;
    private Properties workingSvnProperties = null;
    private Properties baseSvnProperties = null;
    protected File propertiesFile = null;
    private File basePropertiesFile = null;
    private File textBaseFile = null;

    private WorkingCopyDetails(File file, Map<String, String> attributes) {
        this.file = file;
        this.attributes = attributes;
    }

    public static WorkingCopyDetails createWorkingCopy(File file, Map<String, String> attributes) {
        String version;
        String string = version = attributes != null ? attributes.get(VERSION_ATTR_KEY) : VERSION_UNKNOWN;
        if (version != null) {
            if (version.equals(VERSION_13)) {
                return new WorkingCopyDetails(file, attributes);
            }
            if (version.equals(VERSION_14)) {
                return new WorkingCopyDetails(file, (Map)attributes){

                    public boolean propertiesExist() throws IOException {
                        return this.getAttributes().containsKey("has-props");
                    }

                    public boolean propertiesModified() throws IOException {
                        return this.getAttributes().containsKey("has-prop-mods");
                    }

                    File getPropertiesFile() throws IOException {
                        if (this.propertiesFile == null) {
                            boolean modified = this.getBooleanValue("has-prop-mods");
                            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.getFile(), !modified);
                        }
                        return this.propertiesFile;
                    }
                };
            }
            if (version.equals(VERSION_UNKNOWN)) {
                WorkingCopyDetails wcd = new WorkingCopyDetails(file, attributes);
                if (!wcd.isHandled()) {
                    return wcd;
                }
                throw new UnsupportedOperationException("Unknown SVN working copy version: " + version);
            }
            throw new UnsupportedOperationException("Unknown SVN working copy version: " + version);
        }
        ErrorManager.getDefault().log(16, "Could not determine the SVN working copy version for " + file + ". Falling back on 1.3");
        return new WorkingCopyDetails(file, attributes);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected File getFile() {
        return this.file;
    }

    public String getValue(String propertyName, String defaultValue) {
        String returnValue = this.getValue(propertyName);
        return returnValue != null ? returnValue : defaultValue;
    }

    public String getValue(String key) {
        if (key == null) {
            return null;
        }
        return this.getAttributes() != null ? this.getAttributes().get(key) : null;
    }

    public long getLongValue(String key) throws LocalSubversionException {
        try {
            String value = this.getValue(key);
            if (value == null) {
                return -1L;
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    public Date getDateValue(String key) throws LocalSubversionException {
        try {
            String value = this.getValue(key);
            if (value == null || value.equals(VERSION_UNKNOWN)) {
                return null;
            }
            return SvnWcUtils.parseSvnDate(value);
        }
        catch (ParseException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    public boolean getBooleanValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean isHandled() {
        return this.getBooleanValue(IS_HANDLED);
    }

    public boolean isFile() {
        return this.getAttributes() != null ? FILE_ATTRIBUTE_VALUE.equals(this.getAttributes().get("kind")) : false;
    }

    File getPropertiesFile() throws IOException {
        if (this.propertiesFile == null) {
            this.propertiesFile = SvnWcUtils.getPropertiesFile(this.file, false);
        }
        return this.propertiesFile;
    }

    File getBasePropertiesFile() throws IOException {
        if (this.basePropertiesFile == null) {
            this.basePropertiesFile = SvnWcUtils.getPropertiesFile(this.file, true);
        }
        return this.basePropertiesFile;
    }

    private File getTextBaseFile() throws IOException {
        if (this.textBaseFile == null) {
            this.textBaseFile = SvnWcUtils.getTextBaseFile(this.file);
        }
        return this.textBaseFile;
    }

    private Properties getWorkingSvnProperties() throws IOException {
        if (this.workingSvnProperties == null) {
            this.workingSvnProperties = this.loadProperties(this.getPropertiesFile());
        }
        return this.workingSvnProperties;
    }

    private Properties getBaseSvnProperties() throws IOException {
        if (this.baseSvnProperties == null) {
            this.baseSvnProperties = this.loadProperties(this.getBasePropertiesFile());
        }
        return this.baseSvnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propertiesExist() throws IOException {
        boolean returnValue = false;
        File propsFile = this.getPropertiesFile();
        boolean bl = returnValue = propsFile != null ? propsFile.exists() : false;
        if (returnValue) {
            FileInputStream inputStream = new FileInputStream(propsFile);
            try {
                int size;
                int retval = ((InputStream)inputStream).read();
                for (size = 0; retval != -1 && size < 5; ++size) {
                    retval = ((InputStream)inputStream).read();
                }
                returnValue = size > 4;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        return returnValue;
    }

    public boolean propertiesModified() throws IOException {
        Properties props;
        File basePropsFile = this.getPropertiesFile();
        File propsFile = this.getBasePropertiesFile();
        if (basePropsFile == null && propsFile != null) {
            return true;
        }
        if (basePropsFile != null && propsFile == null) {
            return true;
        }
        if (basePropsFile == null && propsFile == null) {
            return false;
        }
        Properties baseProps = this.getBaseSvnProperties();
        return !baseProps.equals(props = this.getWorkingSvnProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File propsFile) throws IOException {
        if (propsFile == null || !propsFile.exists()) {
            return null;
        }
        Properties returnValue = new Properties();
        BufferedReader fileReader = new BufferedReader(new FileReader(propsFile));
        try {
            String currentLine = fileReader.readLine();
            String propKey = null;
            String propValue = VERSION_UNKNOWN;
            boolean headerLine = true;
            while (currentLine != null) {
                if (!headerLine) {
                    if (propKey == null) {
                        propKey = currentLine;
                    } else {
                        propValue = currentLine;
                        returnValue.setProperty(propKey, propValue);
                        propKey = null;
                        propValue = VERSION_UNKNOWN;
                    }
                }
                headerLine = !headerLine;
                currentLine = fileReader.readLine();
            }
        }
        finally {
            fileReader.close();
        }
        return returnValue;
    }

    public boolean textModified() throws IOException {
        boolean returnValue = false;
        if (this.file.exists()) {
            File baseFile = this.getTextBaseFile();
            if (this.file == null && baseFile != null) {
                return true;
            }
            if (this.file != null && baseFile == null) {
                return true;
            }
            if (this.file == null && baseFile == null) {
                return false;
            }
            Properties workingSvnProps = this.getWorkingSvnProperties();
            String value = VERSION_UNKNOWN;
            if (workingSvnProps != null) {
                value = workingSvnProps.getProperty("svn:special", "none");
            }
            if (value.equals("*")) {
                if (this.isSymbolicLink()) {
                    returnValue = false;
                }
            } else {
                String rawKeywords = workingSvnProps != null ? workingSvnProps.getProperty("svn:keywords") : null;
                returnValue = rawKeywords != null ? this.isModifiedByLine(rawKeywords.trim()) : this.isModifiedByByte();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSymbolicLink() throws IOException {
        boolean returnValue = false;
        File baseFile = this.getTextBaseFile();
        if (baseFile != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(baseFile));
                String firstLine = reader.readLine();
                returnValue = firstLine.startsWith("link");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByByte() throws IOException {
        boolean returnValue = false;
        InputStream baseStream = null;
        InputStream fileStream = null;
        try {
            baseStream = new BufferedInputStream(new FileInputStream(this.textBaseFile));
            fileStream = new BufferedInputStream(new FileInputStream(this.file));
            int baseRetVal = baseStream.read();
            int fileRetVal = fileStream.read();
            while (baseRetVal != -1) {
                if (baseRetVal != fileRetVal) {
                    boolean isLineEnding = false;
                    if ('\n' == (char)baseRetVal && '\r' == (char)fileRetVal) {
                        fileRetVal = fileStream.read();
                        isLineEnding = '\n' == (char)fileRetVal;
                    } else if ('\n' == (char)fileRetVal && '\r' == (char)baseRetVal) {
                        baseRetVal = baseStream.read();
                        boolean bl = isLineEnding = '\n' == (char)baseRetVal;
                    }
                    if (!isLineEnding) {
                        boolean bl = true;
                        return bl;
                    }
                }
                baseRetVal = baseStream.read();
                fileRetVal = fileStream.read();
            }
            returnValue = fileRetVal != -1;
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
            if (baseStream != null) {
                baseStream.close();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedByLine(String rawKeywords) throws IOException {
        boolean returnValue = false;
        String[] keywords = rawKeywords.split(" ");
        ArrayList<String> keywordsList = new ArrayList<String>();
        for (int i = 0; i < keywords.length; ++i) {
            String kw = keywords[i].toLowerCase();
            if (kw.equals("date") || kw.equals("lastchangeddate")) {
                keywordsList.add("LastChangedDate");
                keywordsList.add("Date");
                continue;
            }
            if (kw.equals("revision") || kw.equals("rev") || kw.equals("lastchangedrevision")) {
                keywordsList.add("LastChangedRevision");
                keywordsList.add("Revision");
                keywordsList.add("Rev");
                continue;
            }
            if (kw.equals("author") || kw.equals("lastchangedby")) {
                keywordsList.add("LastChangedBy");
                keywordsList.add("Author");
                continue;
            }
            if (kw.equals("url") || kw.equals("headurl")) {
                keywordsList.add("HeadURL");
                keywordsList.add("URL");
                continue;
            }
            keywordsList.add(keywords[i]);
        }
        keywords = keywordsList.toArray(new String[keywordsList.size()]);
        BufferedReader baseReader = null;
        BufferedReader fileReader = null;
        try {
            baseReader = new BufferedReader(new FileReader(this.textBaseFile));
            fileReader = new BufferedReader(new FileReader(this.file));
            String baseLine = baseReader.readLine();
            String fileLine = fileReader.readLine();
            while (baseLine != null && fileLine != null) {
                if (!fileLine.equals(baseLine)) {
                    boolean equal = false;
                    for (int i = 0; i < keywords.length; ++i) {
                        String headerPattern = "$" + keywords[i];
                        if (fileLine.indexOf(headerPattern) <= -1) continue;
                        equal = this.compareKeywordLines(fileLine, baseLine, keywords);
                        break;
                    }
                    if (!equal) {
                        boolean bl = true;
                        return bl;
                    }
                }
                baseLine = baseReader.readLine();
                fileLine = fileReader.readLine();
            }
            returnValue = baseLine != null || fileLine != null;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (baseReader != null) {
                baseReader.close();
            }
        }
        return returnValue;
    }

    private boolean compareKeywordLines(String modifiedLine, String baseLine, String[] keywords) {
        int modifiedIdx = 0;
        for (int fileIdx = 0; fileIdx < baseLine.length(); ++fileIdx) {
            if (baseLine.charAt(fileIdx) == '$') {
                for (int keywordsIdx = 0; keywordsIdx < keywords.length; ++keywordsIdx) {
                    String keyword = keywords[keywordsIdx];
                    boolean gotHeader = false;
                    for (int keyIdx = 0; keyIdx < keyword.length(); ++keyIdx) {
                        if (fileIdx + keyIdx + 1 > baseLine.length() - 1 || keyword.charAt(keyIdx) != baseLine.charAt(fileIdx + keyIdx + 1)) {
                            gotHeader = false;
                            break;
                        }
                        gotHeader = true;
                    }
                    if (!gotHeader) continue;
                    if (this.checkFollowingString(baseLine, fileIdx += keyword.length(), "$")) {
                        ++fileIdx;
                    } else if (this.checkFollowingString(baseLine, fileIdx, ":$")) {
                        fileIdx += 2;
                    } else {
                        return false;
                    }
                    modifiedIdx += keyword.length() + 1;
                    while (++modifiedIdx < modifiedLine.length() && modifiedLine.charAt(modifiedIdx) != '$') {
                    }
                    if (modifiedIdx < modifiedLine.length()) break;
                    return false;
                }
            }
            if (modifiedLine.charAt(modifiedIdx) != baseLine.charAt(fileIdx)) {
                return false;
            }
            if (++modifiedIdx < modifiedLine.length()) continue;
            return fileIdx == baseLine.length() - 1;
        }
        return modifiedIdx == modifiedLine.length() - 2;
    }

    private boolean checkFollowingString(String baseLine, int offset, String str) {
        if (baseLine.length() < offset + str.length()) {
            return false;
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            if (baseLine.charAt(offset + idx + 1) == str.charAt(idx)) continue;
            return false;
        }
        return true;
    }
}

