/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.sql.Date;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CreateFolderAction
extends BrowserAction
implements PropertyChangeListener {
    private final String defaultFolderName;

    public CreateFolderAction(String defaultFolderName) {
        this.defaultFolderName = defaultFolderName;
        this.putValue("Name", NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Action_MakeDir"));
        this.setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.setEnabled(this.isEnabled());
        }
    }

    public boolean isEnabled() {
        Browser browser = this.getBrowser();
        if (browser == null) {
            return false;
        }
        if (browser.getBrowserPanel() == null) {
            return false;
        }
        if (browser.getExplorerManager().getRootContext() == Node.EMPTY) {
            return false;
        }
        Node[] nodes = this.getBrowser().getSelectedNodes();
        if (nodes.length != 1) {
            return false;
        }
        return nodes[0] instanceof RepositoryPathNode && ((RepositoryPathNode)nodes[0]).getEntry().getSvnNodeKind() == SVNNodeKind.DIR;
    }

    public void setBrowser(Browser browser) {
        Browser oldBrowser = this.getBrowser();
        if (oldBrowser != null) {
            oldBrowser.removePropertyChangeListener(this);
        }
        browser.addPropertyChangeListener(this);
        super.setBrowser(browser);
    }

    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Node[] nodes = CreateFolderAction.this.getSelectedNodes();
                if (nodes.length > 1) {
                    return;
                }
                RepositoryPathNode repositoryPathNode = (RepositoryPathNode)nodes[0];
                Children children = repositoryPathNode.getChildren();
                Node[] childNodes = children.getNodes();
                if (childNodes.length > 0) {
                    try {
                        CreateFolderAction.this.getExplorerManager().setSelectedNodes(new Node[]{childNodes[0]});
                    }
                    catch (PropertyVetoException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_NewFolder_Prompt"), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_NewFolder_Title"));
                input.setInputText(CreateFolderAction.this.defaultFolderName);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
                String newDir = input.getInputText().trim();
                if (input.getValue() == DialogDescriptor.CANCEL_OPTION || input.getValue() == DialogDescriptor.CLOSED_OPTION || newDir.equals("")) {
                    return;
                }
                children = repositoryPathNode.getChildren();
                if (children != null && children.getNodesCount() > 0) {
                    childNodes = children.getNodes();
                    for (int i = 0; i < childNodes.length; ++i) {
                        if (!childNodes[i].getDisplayName().equals(newDir)) continue;
                        JButton ok = new JButton(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_OK"));
                        NotifyDescriptor descriptor = new NotifyDescriptor((Object)NbBundle.getMessage(CreateFolderAction.class, (String)"MSG_Browser_FolderExists", (Object)newDir), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("MSG_Browser_WrongFolerName"), -1, 0, new Object[]{ok}, (Object)ok);
                        DialogDisplayer.getDefault().notify(descriptor);
                        return;
                    }
                }
                RepositoryFile parentFile = repositoryPathNode.getEntry().getRepositoryFile();
                RepositoryPathNode segmentNode = repositoryPathNode;
                String[] segments = newDir.split("/");
                for (int i = 0; i < segments.length; ++i) {
                    RepositoryFile newFile = parentFile.appendPath(segments[i]);
                    RepositoryPathNode.RepositoryPathEntry entry = new RepositoryPathNode.RepositoryPathEntry(newFile, SVNNodeKind.DIR, new SVNRevision(0), new Date(System.currentTimeMillis()), "");
                    RepositoryPathNode node = RepositoryPathNode.createBrowserPathNode(CreateFolderAction.this.getBrowser(), entry);
                    Node[] newChild = new Node[]{node};
                    segmentNode.getChildren().add(newChild);
                    segmentNode = node;
                    parentFile = newFile;
                    if (i != segments.length - 1) continue;
                    try {
                        CreateFolderAction.this.setSelectedNodes(newChild);
                        continue;
                    }
                    catch (PropertyVetoException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            }
        });
    }
}

