/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPaths
implements ActionListener,
DocumentListener {
    private static final RepositoryFile[] EMPTY_REPOSITORY_FILES = new RepositoryFile[0];
    private RepositoryFile repositoryFile;
    private JTextComponent repositoryPathTextField;
    private JTextComponent revisionTextField;
    private JButton browseButton;
    private JButton searchRevisionButton;
    private int browserMode;
    private BrowserAction[] browserActions;
    private String browserPurpose;
    private boolean valid = false;
    public static final String PROP_VALID = "valid";
    private List<PropertyChangeListener> listeners;
    private PropertyChangeSupport propertyChangeSupport;

    public RepositoryPaths(RepositoryFile repositoryFile, JTextComponent repositoryPathTextField, JButton browseButton, JTextField revisionTextField, JButton searchRevisionButton) {
        assert (repositoryFile != null);
        assert (repositoryPathTextField != null && browseButton != null || revisionTextField != null && searchRevisionButton != null);
        this.repositoryFile = repositoryFile;
        if (repositoryPathTextField != null) {
            this.repositoryPathTextField = repositoryPathTextField;
            repositoryPathTextField.getDocument().addDocumentListener(this);
            this.browseButton = browseButton;
            if (browseButton != null) {
                browseButton.addActionListener(this);
            }
        }
        if (revisionTextField != null) {
            this.revisionTextField = revisionTextField;
            revisionTextField.getDocument().addDocumentListener(this);
            this.searchRevisionButton = searchRevisionButton;
            if (searchRevisionButton != null) {
                searchRevisionButton.addActionListener(this);
            }
        }
    }

    public void setupBrowserBehavior(String browserPurpose, int browserMode) {
        this.browserMode = browserMode;
        this.browserPurpose = browserPurpose;
    }

    public void setupBrowserBehavior(String browserPurpose, int browserMode, BrowserAction[] browserActions) {
        this.setupBrowserBehavior(browserPurpose, browserMode);
        this.browserActions = browserActions;
        this.browserPurpose = browserPurpose;
    }

    public RepositoryFile[] getRepositoryFiles() throws MalformedURLException, NumberFormatException {
        return this.getRepositoryFiles(null);
    }

    public RepositoryFile[] getRepositoryFiles(String defaultPath) throws MalformedURLException, NumberFormatException {
        SVNRevision revision = this.getRevision();
        if (this.repositoryPathTextField == null) {
            RepositoryFile rf = new RepositoryFile(this.repositoryFile.getRepositoryUrl(), this.repositoryFile.getFileUrl(), revision);
            return new RepositoryFile[]{rf};
        }
        if (this.getRepositoryString().equals("")) {
            if (defaultPath != null && !defaultPath.trim().equals("")) {
                return new RepositoryFile[]{new RepositoryFile(this.getRepositoryUrl(), defaultPath, revision)};
            }
            return EMPTY_REPOSITORY_FILES;
        }
        if (revision == null) {
            return EMPTY_REPOSITORY_FILES;
        }
        String[] paths = this.getRepositoryString().split(",");
        RepositoryFile[] ret = new RepositoryFile[paths.length];
        SVNUrl repositoryUrl = this.getRepositoryUrl();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i].trim();
            String repositoryUrlString = this.getRepositoryUrl().toString();
            if (path.startsWith("file://") || path.startsWith("http://") || path.startsWith("https://") || path.startsWith("svn://") || path.startsWith("svn+ssh://")) {
                if (path.startsWith(repositoryUrlString)) {
                    ret[i] = new RepositoryFile(repositoryUrl, path.substring(repositoryUrlString.length()), revision);
                    continue;
                }
                throw new MalformedURLException(NbBundle.getMessage(RepositoryPaths.class, (String)"MSG_RepositoryPath_WrongStart", (Object)path, (Object)repositoryUrlString));
            }
            ret[i] = new RepositoryFile(repositoryUrl, path, revision);
        }
        return ret;
    }

    private void browseRepository() {
        RepositoryFile[] repositoryFilesToSelect;
        SVNRevision revision = this.getRevision();
        try {
            repositoryFilesToSelect = this.getRepositoryFiles();
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        final Browser browser = new Browser(this.browserPurpose, this.browserMode, new RepositoryFile(this.getRepositoryUrl(), revision), repositoryFilesToSelect, this.browserActions);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browser.getBrowserPanel(), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_RepositoryPath_BrowseFolders_Title"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(Browser.class));
        dialogDescriptor.setValid(false);
        browser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    dialogDescriptor.setValid(browser.getSelectedNodes().length > 0);
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryPaths.class, (String)"CTL_RepositoryPath_BrowseFolders_Title"));
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            RepositoryFile[] selectedFiles = browser.getSelectedFiles();
            if (selectedFiles.length > 0) {
                StringBuffer paths = new StringBuffer();
                for (int i = 0; i < selectedFiles.length; ++i) {
                    paths.append(selectedFiles[i].getPath());
                    if (i >= selectedFiles.length - 1) continue;
                    paths.append(", ");
                }
                this.setRepositoryTextField(paths.toString());
            }
        } else {
            browser.cancel();
        }
    }

    private void searchRepository() {
        SVNRevision revision = this.getRevision();
        final SvnSearch svnSearch = new SvnSearch(new RepositoryFile(this.getRepositoryUrl(), revision));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)svnSearch.getSearchPanel(), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_RepositoryPath_SearchRevisions"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(Browser.class));
        dialogDescriptor.setValid(false);
        svnSearch.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                dialogDescriptor.setValid(svnSearch.getSelectedRevision() != null);
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            revision = svnSearch.getSelectedRevision();
            if (revision != null) {
                if (revision.equals((Object)SVNRevision.HEAD)) {
                    this.setRevisionTextField("");
                } else {
                    this.setRevisionTextField(revision.toString());
                }
            }
        } else {
            svnSearch.cancel();
        }
    }

    public SVNRevision getRevision() {
        if (this.revisionTextField == null) {
            return SVNRevision.HEAD;
        }
        String revisionString = this.getRevisionString();
        if (revisionString.equals("")) {
            return SVNRevision.HEAD;
        }
        return SvnUtils.getSVNRevision(revisionString);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            this.browseRepository();
        } else if (e.getSource() == this.searchRevisionButton) {
            this.searchRepository();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean oldValue = this.valid;
        boolean valid = true;
        RepositoryFile[] files = null;
        try {
            files = this.getRepositoryFiles();
        }
        catch (NumberFormatException ex) {
            valid = false;
        }
        catch (MalformedURLException ex) {
            valid = false;
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(valid);
        }
        if (this.searchRevisionButton != null) {
            this.searchRevisionButton.setEnabled(valid);
        }
        if (valid && !this.acceptEmptyUrl() && this.repositoryPathTextField != null && this.getRepositoryString().equals("")) {
            valid = false;
        }
        if (valid && !this.acceptEmptyRevision() && this.revisionTextField != null && this.getRevisionString().equals("")) {
            valid = false;
        }
        this.valid = valid;
        this.fireValidPropertyChanged(oldValue, valid);
    }

    private void fireValidPropertyChanged(boolean oldValue, boolean valid) {
        this.getChangeSupport().firePropertyChange(new PropertyChangeEvent(this, PROP_VALID, new Boolean(oldValue), new Boolean(valid)));
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().addPropertyChangeListener(l);
        this.validateUserInput();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().removePropertyChangeListener(l);
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    protected boolean acceptEmptyUrl() {
        return false;
    }

    protected boolean acceptEmptyRevision() {
        return true;
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryFile.getRepositoryUrl();
    }

    public void setRepositoryFile(RepositoryFile repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public void setRepositoryTextField(String url) {
        this.repositoryPathTextField.setText(url);
    }

    public void setRevisionTextField(String revision) {
        this.revisionTextField.setText(revision);
    }

    protected String getRepositoryString() {
        return this.repositoryPathTextField.getText().trim();
    }

    protected String getRevisionString() {
        return this.revisionTextField.getText().trim();
    }
}

