/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.checkout.CheckoutCompleted;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutAction
extends CallableSystemAction {
    public void performAction() {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        CheckoutWizard wizard = new CheckoutWizard();
        if (!wizard.show()) {
            return;
        }
        final SVNUrl repository = wizard.getRepositoryRoot();
        final RepositoryFile[] repositoryFiles = wizard.getRepositoryFiles();
        final File file = wizard.getWorkdir();
        final boolean atWorkingDirLevel = wizard.isAtWorkingDirLevel();
        SvnProgressSupport support = new SvnProgressSupport(){

            public void perform() {
                SvnClient client;
                try {
                    client = Subversion.getInstance().getClient(repository);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                    return;
                }
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    CheckoutAction.checkout(client, repository, repositoryFiles, file, atWorkingDirLevel, this);
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                    return;
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (SvnModuleConfig.getDefault().getShowCheckoutCompleted()) {
                    String[] folders;
                    if (atWorkingDirLevel) {
                        folders = new String[]{"."};
                    } else {
                        folders = new String[repositoryFiles.length];
                        for (int i = 0; i < repositoryFiles.length; ++i) {
                            if (this.isCanceled()) {
                                return;
                            }
                            folders[i] = repositoryFiles[i].isRepositoryRoot() ? "." : repositoryFiles[i].getFileUrl().getLastPathSegment();
                        }
                    }
                    CheckoutCompleted cc = new CheckoutCompleted(file, folders, true);
                    if (this.isCanceled()) {
                        return;
                    }
                    cc.scanForProjects(this);
                }
            }
        };
        support.start(Subversion.getInstance().getRequestProcessor(repository), repository, ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public String getName() {
        return NbBundle.getMessage(CheckoutAction.class, (String)"CTL_CheckoutAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static void checkout(SvnClient client, SVNUrl repository, RepositoryFile[] repositoryFiles, File workingDir, boolean atWorkingDirLevel, SvnProgressSupport support) throws SVNClientException {
        for (int i = 0; i < repositoryFiles.length; ++i) {
            File destination;
            if (!atWorkingDirLevel) {
                destination = new File(workingDir.getAbsolutePath() + "/" + repositoryFiles[i].getName());
                destination = FileUtil.normalizeFile((File)destination);
                destination.mkdir();
            } else {
                destination = workingDir;
            }
            if (support != null && support.isCanceled()) {
                return;
            }
            client.checkout(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
            if (support == null || !support.isCanceled()) continue;
            return;
        }
    }
}

