/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitPanel
extends JPanel
implements PreferenceChangeListener,
TableModelListener {
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private CommitTable commitTable;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    final JLabel filesLabel = new JLabel();
    final JPanel filesPanel = new JPanel();
    final JLabel jLabel1 = new JLabel();
    final JLabel jLabel2 = new JLabel();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JTextArea messageTextArea = new JTextArea();
    final JLabel recentLink = new JLabel();

    public CommitPanel() {
        this.initComponents();
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String htmlErrorLabel) {
        this.jLabel2.setText(htmlErrorLabel);
    }

    public void addNotify() {
        super.addNotify();
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        List messages = Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage");
        if (messages.size() > 0) {
            this.messageTextArea.setText((String)messages.get(0));
        }
        this.messageTextArea.selectAll();
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    private void onBrowseRecentMessages() {
        String message = StringSelector.select((String)NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitForm_RecentTitle"), (String)NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitForm_RecentPrompt"), (List)Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage"));
        if (message != null) {
            this.messageTextArea.replaceSelection(message);
        }
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(650, 400));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitForm_Message"));
        this.messageTextArea.setColumns(30);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(6);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitForm_FilesToCommit"));
        this.filesPanel.setPreferredSize(new Dimension(240, 108));
        GroupLayout filesPanelLayout = new GroupLayout((Container)this.filesPanel);
        this.filesPanel.setLayout((LayoutManager)filesPanelLayout);
        filesPanelLayout.setHorizontalGroup((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add(0, 630, Short.MAX_VALUE));
        filesPanelLayout.setVerticalGroup((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add(0, 187, Short.MAX_VALUE));
        this.recentLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/recent_messages.png")));
        this.recentLink.setToolTipText(NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitForm_RecentMessages"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.filesPanel, -1, 630, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 630, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 530, Short.MAX_VALUE).add((Component)this.recentLink)).add(1, (Component)this.filesLabel).add(1, (Component)this.jLabel2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.recentLink)).addPreferredGap(0).add((Component)this.jScrollPane1, -2, -1, -2).add(15, 15, 15).add((Component)this.filesLabel).addPreferredGap(0).add((Component)this.filesPanel, -1, 187, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel2).addContainerGap()));
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }
}

