/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitTableModel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTable
implements AncestorListener,
TableModelListener {
    public static String[] COMMIT_COLUMNS = new String[]{"name", "status", "action", "path"};
    public static String[] IMPORT_COLUMNS = new String[]{"name", "action", "path"};
    private CommitTableModel tableModel;
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;
    private String[] sortByColumns;

    public CommitTable(JLabel label, String[] columns, String[] sortByColumns) {
        this.init(label, columns, null);
        this.sortByColumns = sortByColumns;
        this.setSortingStatus();
    }

    public CommitTable(JLabel label, String[] columns, TableSorter sorter) {
        this.init(label, columns, sorter);
    }

    private void init(JLabel label, String[] columns, TableSorter sorter) {
        this.tableModel = new CommitTableModel(columns);
        this.tableModel.addTableModelListener(this);
        if (sorter == null) {
            sorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = sorter;
        this.table = new JTable((TableModel)this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultEditor(CommitOptions.class, new CommitOptionsCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        label.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitTable.class, (String)"ACSD_CommitTable"));
        this.setColumns(columns);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        block14: {
            TableColumnModel columnModel;
            int width;
            block15: {
                block13: {
                    width = this.table.getWidth();
                    columnModel = this.table.getColumnModel();
                    if (this.columns == null || columnModel == null) {
                        return;
                    }
                    if (columnModel.getColumnCount() != this.columns.length) {
                        return;
                    }
                    if (this.columns.length != 3) break block13;
                    for (int i = 0; i < this.columns.length; ++i) {
                        String col = this.columns[i];
                        this.sorter.setColumnComparator(i, null);
                        if (col.equals("name")) {
                            this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                            columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                            continue;
                        }
                        if (col.equals("action")) {
                            columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                            continue;
                        }
                        columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                    }
                    break block14;
                }
                if (this.columns.length != 4) break block15;
                for (int i = 0; i < this.columns.length; ++i) {
                    String col = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    if (col.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                        continue;
                    }
                    if (col.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    if (col.equals("action")) {
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                }
                break block14;
            }
            if (this.columns.length != 5) break block14;
            for (int i = 0; i < this.columns.length; ++i) {
                String col = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                if (col.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    columnModel.getColumn(i).setPreferredWidth(width * 25 / 100);
                    continue;
                }
                if (col.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                if (col.equals("action")) {
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
            }
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String sortByColumn = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String column = this.columns[j];
                if (!column.equals(sortByColumn)) continue;
                this.sorter.setSortingStatus(j, column.equals(sortByColumn) ? 1 : 0);
                continue block0;
            }
        }
    }

    public TableSorter getSorter() {
        return this.sorter;
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(this.columns, cols)) {
            return;
        }
        this.columns = cols;
        this.tableModel.setColumns(cols);
        this.setDefaultColumnSizes();
    }

    public void setNodes(SvnFileNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.table.repaint();
    }

    public void setRootFile(String repositoryPath, String rootLocalPath) {
        this.tableModel.setRootFile(repositoryPath, rootLocalPath);
    }

    private class CommitOptionsCellEditor
    extends DefaultCellEditor {
        private final Object[] dirAddOptions;
        private final Object[] addOptions;
        private final Object[] commitOptions;
        private final Object[] removeOptions;

        public CommitOptionsCellEditor() {
            super(new JComboBox());
            this.dirAddOptions = new Object[]{CommitOptions.ADD_DIRECTORY, CommitOptions.EXCLUDE};
            this.addOptions = new Object[]{CommitOptions.ADD_TEXT, CommitOptions.ADD_BINARY, CommitOptions.EXCLUDE};
            this.commitOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.removeOptions = new Object[]{CommitOptions.COMMIT_REMOVE, CommitOptions.EXCLUDE};
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            FileInformation info = CommitTable.this.tableModel.getNode(CommitTable.this.sorter.modelIndex(row)).getInformation();
            int fileStatus = info.getStatus();
            JComboBox combo = (JComboBox)this.editorComponent;
            if (fileStatus == 2048 || fileStatus == 256) {
                combo.setModel(new DefaultComboBoxModel<Object>(this.removeOptions));
            } else if ((fileStatus & 0xFF8) == 0) {
                if (info.isDirectory()) {
                    combo.setModel(new DefaultComboBoxModel<Object>(this.dirAddOptions));
                } else {
                    combo.setModel(new DefaultComboBoxModel<Object>(this.addOptions));
                }
            } else {
                combo.setModel(new DefaultComboBoxModel<Object>(this.commitOptions));
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col = table.convertColumnIndexToModel(column);
            if (CommitTable.this.columns[col] == "name") {
                TableSorter sorter = (TableSorter)table.getModel();
                CommitTableModel model = (CommitTableModel)sorter.getTableModel();
                SvnFileNode node = model.getNode(sorter.modelIndex(row));
                CommitOptions options = model.getOptions(sorter.modelIndex(row));
                if (!isSelected) {
                    value = "<html>" + Subversion.getInstance().getAnnotator().annotateNameHtml(node.getFile().getName(), node.getInformation(), null);
                }
                if (options == CommitOptions.EXCLUDE) {
                    value = "<html><s>" + value + "</s></html>";
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (CommitTable.this.columns[col] == "path") {
                return this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return CommitTable.this.tableModel.getNode(row1).getName().compareToIgnoreCase(CommitTable.this.tableModel.getNode(row2).getName());
        }
    }

    private class StatusComparator
    extends SvnUtils.ByImportanceComparator {
        private StatusComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return super.compare(CommitTable.this.tableModel.getNode(row1).getInformation(), CommitTable.this.tableModel.getNode(row2).getInformation());
        }
    }
}

