/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTableModel
extends AbstractTableModel {
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    private Set<SVNUrl> repositoryRoots;
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private CommitOptions[] commitOptions;
    private SvnFileNode[] nodes;
    private String[] columns;

    public CommitTableModel(String[] columns) {
        ResourceBundle loc = NbBundle.getBundle(CommitTableModel.class);
        columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_BRANCH, new String[]{loc.getString("CTL_CommitTable_Column_Branch"), loc.getString("CTL_CommitTable_Column_Branch")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(columns);
        this.setNodes(new SvnFileNode[0]);
    }

    void setNodes(SvnFileNode[] nodes) {
        this.nodes = nodes;
        this.defaultCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        HashMap<SvnFileNode, CommitOptions> ret = new HashMap<SvnFileNode, CommitOptions>(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            ret.put(this.nodes[i], this.commitOptions[i]);
        }
        return ret;
    }

    @Override
    public String getColumnName(int column) {
        return columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_ACTION)) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals(COLUMN_NAME_ACTION);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_NAME)) {
            return this.nodes[rowIndex].getName();
        }
        if (col.equals(COLUMN_NAME_BRANCH)) {
            String branch = SvnUtils.getCopy(this.nodes[rowIndex].getFile());
            return branch == null ? "" : branch;
        }
        if (col.equals(COLUMN_NAME_STATUS)) {
            SvnFileNode node = this.nodes[rowIndex];
            FileInformation finfo = node.getInformation();
            finfo.getEntry(node.getFile());
            return finfo.getStatusText();
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return this.commitOptions[rowIndex];
        }
        if (col.equals(COLUMN_NAME_PATH)) {
            String shortPath = null;
            if (this.rootFile != null) {
                String relativePath = this.nodes[rowIndex].getFile().getAbsolutePath().substring(this.rootFile.rootLocalPath.length());
                shortPath = this.rootFile.repositoryPath + relativePath.replace(File.separatorChar, '/');
            } else {
                Set<SVNUrl> url = this.getRepositoryRoots();
                try {
                    for (SVNUrl nextUrl : url) {
                        shortPath = SvnUtils.getRelativePath(nextUrl, this.nodes[rowIndex].getFile());
                    }
                    if (shortPath == null) {
                        SVNUrl newUrl = SvnUtils.getRepositoryRootUrl(this.nodes[rowIndex].getFile());
                        shortPath = SvnUtils.getRelativePath(newUrl, this.nodes[rowIndex].getFile());
                        url.add(newUrl);
                    }
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
                if (shortPath == null) {
                    shortPath = NbBundle.getMessage(CommitTableModel.class, (String)"CTL_CommitForm_NotInRepository");
                }
            }
            return shortPath;
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (!col.equals(COLUMN_NAME_ACTION)) {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.commitOptions[rowIndex] = (CommitOptions)aValue;
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    private void defaultCommitOptions() {
        boolean excludeNew = System.getProperty("netbeans.subversion.excludeNewFiles") != null;
        this.commitOptions = new CommitOptions[this.nodes.length];
        block4: for (int i = 0; i < this.nodes.length; ++i) {
            SvnFileNode node = this.nodes[i];
            File file = node.getFile();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) {
                this.commitOptions[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (node.getInformation().getStatus()) {
                case 4: {
                    this.commitOptions[i] = excludeNew ? CommitOptions.EXCLUDE : this.getDefaultCommitOptions(node.getFile());
                    continue block4;
                }
                case 256: 
                case 2048: {
                    this.commitOptions[i] = CommitOptions.COMMIT_REMOVE;
                    continue block4;
                }
                default: {
                    this.commitOptions[i] = CommitOptions.COMMIT;
                }
            }
        }
    }

    public SvnFileNode getNode(int row) {
        return this.nodes[row];
    }

    public CommitOptions getOptions(int row) {
        return this.commitOptions[row];
    }

    private CommitOptions getDefaultCommitOptions(File file) {
        if (file.isFile()) {
            if (SvnUtils.isFileContentBinary(file)) {
                return CommitOptions.ADD_BINARY;
            }
            return CommitOptions.ADD_TEXT;
        }
        return CommitOptions.ADD_DIRECTORY;
    }

    private Set<SVNUrl> getRepositoryRoots() {
        if (this.repositoryRoots == null) {
            this.repositoryRoots = new HashSet<SVNUrl>();
        }
        return this.repositoryRoots;
    }

    void setRootFile(String repositoryPath, String rootLocalPath) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = repositoryPath;
        this.rootFile.rootLocalPath = rootLocalPath;
    }

    private class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

