/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CreateCopyAction
extends ContextAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Copy";
    }

    protected int getFileEnabledStatus() {
        return -4;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected void performContextAction(Node[] nodes) {
        SVNUrl fileUrl;
        SVNUrl repositoryUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        File root = ctx.getRootFiles()[0];
        File[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 6612);
        boolean hasChanges = files.length > 0;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(root);
            fileUrl = SvnUtils.getRepositoryUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.HEAD);
        final CreateCopy createCopy = new CreateCopy(repositoryFile, root, hasChanges);
        if (createCopy.showDialog()) {
            ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

                public void perform() {
                    CreateCopyAction.this.performCopy(createCopy, this);
                }
            };
            support.start(this.createRequestProcessor(nodes));
        }
    }

    private void performCopy(CreateCopy createCopy, SvnProgressSupport support) {
        RepositoryFile toRepositoryFile = createCopy.getToRepositoryFile();
        try {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (!toRepositoryFile.isRepositoryRoot()) {
                ISVNInfo info;
                SVNUrl folderToCreate;
                block16: {
                    folderToCreate = toRepositoryFile.removeLastSegment().getFileUrl();
                    info = null;
                    try {
                        info = client.getInfo(folderToCreate);
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isWrongUrl(ex.getMessage())) break block16;
                        throw ex;
                    }
                }
                if (support.isCanceled()) {
                    return;
                }
                if (info == null) {
                    client.mkdir(folderToCreate, true, "[Netbeans SVN client generated message: create a new folder for the copy]: '\n" + createCopy.getMessage() + "\n'");
                } else if (createCopy.getLocalFile().isFile()) {
                    throw new SVNClientException("File allready exists");
                }
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.isLocal()) {
                client.copy(createCopy.getLocalFile(), toRepositoryFile.getFileUrl(), createCopy.getMessage());
            } else {
                RepositoryFile fromRepositoryFile = createCopy.getFromRepositoryFile();
                client.copy(fromRepositoryFile.getFileUrl(), toRepositoryFile.getFileUrl(), createCopy.getMessage(), fromRepositoryFile.getRevision());
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.switchTo()) {
                SwitchToAction.performSwitch(toRepositoryFile, createCopy.getLocalFile(), support);
            }
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

