/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SearchCriteriaPanel
extends JPanel {
    private final File[] roots;
    private final SVNUrl url;
    private JButton bBrowseFrom;
    private JButton bBrowseTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;

    public SearchCriteriaPanel(File[] roots) {
        this.roots = roots;
        this.url = null;
        this.initComponents();
    }

    public SearchCriteriaPanel(SVNUrl url) {
        this.url = url;
        this.roots = null;
        this.initComponents();
    }

    public SVNRevision getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.length() == 0) {
            return new SVNRevision.Number(1L);
        }
        return this.toRevision(s);
    }

    public SVNRevision getTo() {
        String s = this.tfTo.getText().trim();
        if (s.length() == 0) {
            return SVNRevision.HEAD;
        }
        return this.toRevision(s);
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < SearchExecutor.dateFormats.length; ++i) {
            DateFormat dateformat = SearchExecutor.dateFormats[i];
            try {
                return dateformat.parse(s);
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }

    private SVNRevision toRevision(String s) {
        Date date = this.parseDate(s);
        if (date != null) {
            return new SVNRevision.DateSpec(date);
        }
        if ("BASE".equals(s)) {
            return SVNRevision.BASE;
        }
        if ("HEAD".equals(s)) {
            return SVNRevision.HEAD;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.length() > 0 ? s : null;
    }

    public void setFrom(String from) {
        if (from == null) {
            from = "";
        }
        this.tfFrom.setText(from);
    }

    public void setTo(String to) {
        if (to == null) {
            to = "";
        }
        this.tfTo.setText(to);
    }

    public void setCommitMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.tfCommitMessage.setText(message);
    }

    public void setUsername(String username) {
        if (username == null) {
            username = "";
        }
        this.tfUsername.setText(username);
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.jLabel2 = new JLabel();
        this.tfUsername = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.bBrowseFrom = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.bBrowseTo = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.jLabel1.setLabelFor(this.tfCommitMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("CTL_UseCommitMessage"));
        this.jLabel1.setToolTipText(bundle.getString("TT_CommitMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.tfCommitMessage.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfCommitMessage, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("CTL_UseUsername"));
        this.jLabel2.setToolTipText(bundle.getString("TT_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.tfUsername.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfUsername, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)bundle.getString("CTL_UseFrom"));
        this.jLabel3.setToolTipText(bundle.getString("TT_From"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.tfFrom.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfFrom, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)bundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.add((Component)this.jLabel5, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseFrom, (String)bundle.getString("CTL_BrowseFrom"));
        this.bBrowseFrom.setToolTipText(bundle.getString("TT_BrowseFrom"));
        this.bBrowseFrom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onFromBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseFrom, gridBagConstraints);
        this.jLabel4.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)bundle.getString("CTL_UseTo"));
        this.jLabel4.setToolTipText(bundle.getString("TT_To"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.tfTo.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfTo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)bundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 0, 4);
        this.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseTo, (String)bundle.getString("CTL_BrowseTo"));
        this.bBrowseTo.setToolTipText(bundle.getString("TT_BrowseTo"));
        this.bBrowseTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onToBrowse(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.bBrowseTo, gridBagConstraints);
    }

    private void onToBrowse(ActionEvent evt) {
        this.onBrowse(this.tfTo);
    }

    private void onFromBrowse(ActionEvent evt) {
        this.onBrowse(this.tfFrom);
    }

    private void onBrowse(final JTextField destination) {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = this.url != null ? this.url : SvnUtils.getRepositoryRootUrl(this.roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        String title = destination == this.tfFrom ? NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_StartTag") : NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_EndTag");
        RepositoryFile repoFile = new RepositoryFile(repositoryUrl, SVNRevision.HEAD);
        int browserMode = this.roots[0].isFile() ? 11 : 1;
        final Browser browser = new Browser(title, browserMode, repoFile, null, null);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browser.getBrowserPanel(), NbBundle.getMessage(SearchCriteriaPanel.class, (String)"LBL_Search_BrowseRepository"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(Browser.class));
        dialogDescriptor.setValid(false);
        browser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    dialogDescriptor.setValid(browser.getSelectedNodes().length > 0);
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (!DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            browser.cancel();
            return;
        }
        final SVNUrl tagURL = browser.getSelectedFiles()[0].getFileUrl();
        destination.setText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"MSG_Search_PleaseWait"));
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        SvnProgressSupport support = new SvnProgressSupport(){

            public void perform() {
                SearchCriteriaPanel.this.processTagSelection(destination, repositoryUrl, tagURL, this);
            }
        };
        support.start(rp, repositoryUrl, NbBundle.getMessage(SearchCriteriaPanel.class, (String)"MSG_Search_ResolvingTagProgress"));
    }

    private void processTagSelection(final JTextField destination, SVNUrl repositoryURL, SVNUrl tagURL, SvnProgressSupport progress) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(repositoryURL, progress);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        ISVNLogMessage[] log = new ISVNLogMessage[]{};
        try {
            log = client.getLogMessages(tagURL, null, (SVNRevision)new SVNRevision.Number(1L), SVNRevision.HEAD, true, false, 1L);
        }
        catch (SVNClientException e) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
            return;
        }
        final SVNRevision.Number revision = log[0].getRevision();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                destination.setText(Long.toString(revision.getNumber()));
            }
        });
    }
}

