/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;

    public SummaryView(SearchHistoryPanel master, List<RepositoryRevision> results) {
        this.master = master;
        this.results = results;
        this.dispResults = this.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private List expandResults(List<RepositoryRevision> results) {
        ArrayList<Object> newResults = new ArrayList<Object>(results.size());
        for (RepositoryRevision repositoryRevision : results) {
            newResults.add(repositoryRevision);
            List<RepositoryRevision.Event> events = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : events) {
                newResults.add(event);
            }
        }
        return newResults;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx)) != null && diffBounds.contains(p)) {
            this.revertModifications(new int[]{idx});
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public Collection getSetups() {
        int[] sel;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int i : sel = this.resultsList.getSelectedIndices()) {
            Object revCon = this.dispResults.get(i);
            if (revCon instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)revCon);
                continue;
            }
            events.add((RepositoryRevision.Event)revCon);
        }
        return this.master.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void onPopup(MouseEvent e) {
        RepositoryRevision.Event drev;
        boolean revisionSelected;
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length == 0) {
            int idx = this.resultsList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        Object previousRevision = null;
        RepositoryRevision container = null;
        Object revCon = this.dispResults.get(selection[0]);
        if (revCon instanceof RepositoryRevision) {
            revisionSelected = true;
            container = (RepositoryRevision)this.dispResults.get(selection[0]);
            drev = null;
        } else {
            revisionSelected = false;
            drev = (RepositoryRevision.Event)this.dispResults.get(selection[0]);
            container = drev.getLogInfoHeader();
        }
        long revision = container.getLog().getRevision().getNumber();
        if (revision > 1L) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", previousRevision)){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1);
                }

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(x0);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent e) {
                SummaryView.this.revertModifications(selection);
            }
        }));
        if (!revisionSelected) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)revision)){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && !revisionSelected);
                }

                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.rollback(drev);
                        }
                    });
                }
            }));
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && !revisionSelected && drev.getFile() != null);
                }

                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.this.view(selection[0]);
                        }
                    });
                }
            }));
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    static void rollback(final RepositoryRevision.Event event) {
        SVNUrl repository = event.getLogInfoHeader().getRepositoryRootUrl();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            public void perform() {
                SummaryView.rollback(event, this);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(SummaryView.class, (String)"MSG_Rollback_Progress"));
    }

    private static void rollback(RepositoryRevision.Event event, SvnProgressSupport progress) {
        File file = event.getFile();
        File parent = file.getParentFile();
        parent.mkdirs();
        try {
            File oldFile = VersionsCache.getInstance().getFileRevision(event.getFile(), Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()));
            file.delete();
            FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)oldFile), (FileObject)FileUtil.toFileObject((File)parent), (String)file.getName(), (String)"");
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void revertModifications(int[] selection) {
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (int idx : selection) {
            Object o = this.dispResults.get(idx);
            if (o instanceof RepositoryRevision) {
                revisions.add((RepositoryRevision)o);
                continue;
            }
            events.add((RepositoryRevision.Event)o);
        }
        SummaryView.revert(this.master, revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    static void revert(final SearchHistoryPanel master, final RepositoryRevision[] revisions, final RepositoryRevision.Event[] events) {
        SVNUrl url;
        try {
            url = master.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
        SvnProgressSupport support = new SvnProgressSupport(){

            public void perform() {
                SummaryView.revertImpl(master, revisions, events, this);
            }
        };
        support.start(rp, url, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    private static void revertImpl(SearchHistoryPanel master, RepositoryRevision[] revisions, RepositoryRevision.Event[] events, SvnProgressSupport progress) {
        Context ctx;
        RevertModifications revertModifications;
        SVNUrl url;
        try {
            url = master.getSearchRepositoryRootUrl();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(url, url, SVNRevision.HEAD);
        for (RepositoryRevision revision : revisions) {
            revertModifications = new RevertModifications(repositoryFile, Long.toString(revision.getLog().getRevision().getNumber()));
            ctx = new Context(master.getRoots());
            RevertModificationsAction.performRevert(ctx, revertModifications, progress);
        }
        for (RepositoryRevision.Event event : events) {
            if (event.getFile() == null) continue;
            revertModifications = new RevertModifications(repositoryFile, Long.toString(event.getLogInfoHeader().getLog().getRevision().getNumber()));
            ctx = new Context(event.getFile());
            RevertModificationsAction.performRevert(ctx, revertModifications, progress);
        }
    }

    private void view(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            FileObject fo = FileUtil.toFileObject((File)drev.getFile());
            Utils.openFile((FileObject)fo, (String)drev.getLogInfoHeader().getLog().getRevision().toString());
        }
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event drev = (RepositoryRevision.Event)o;
            this.master.showDiff(drev);
        } else {
            RepositoryRevision container = (RepositoryRevision)o;
            this.master.showDiff(container);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel revertLink;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (c != null) {
                StyleConstants.setBackground(this.hiliteStyle, c);
            }
            if ((c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, c);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPane.add(this.diffLink);
            this.revertLink = new HyperlinkLabel();
            this.actionsPane.add(this.revertLink);
            this.textPane.setBorder(null);
        }

        public Color darker(Color c) {
            return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RepositoryRevision) {
                this.renderContainer(list, (RepositoryRevision)value, index, isSelected);
            } else {
                this.renderRevision(list, (RepositoryRevision.Event)value, index, isSelected);
            }
            return this;
        }

        private void renderContainer(JList list, RepositoryRevision container, int index, boolean isSelected) {
            Style style;
            Color backgroundColor;
            Color foregroundColor;
            StyledDocument sd = this.textPane.getStyledDocument();
            if (isSelected) {
                foregroundColor = UIManager.getColor("List.selectionForeground");
                backgroundColor = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                foregroundColor = UIManager.getColor("List.foreground");
                backgroundColor = UIManager.getColor("List.background");
                backgroundColor = this.darker(backgroundColor);
                style = this.normalStyle;
            }
            this.textPane.setBackground(backgroundColor);
            this.actionsPane.setBackground(backgroundColor);
            this.index = index;
            try {
                int width;
                int idx;
                sd.remove(0, sd.getLength());
                sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                sd.insertString(0, Long.toString(container.getLog().getRevision().getNumber()), null);
                sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                sd.insertString(sd.getLength(), FIELDS_SEPARATOR + container.getLog().getAuthor(), null);
                sd.insertString(sd.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(container.getLog().getDate()), null);
                String commitMessage = container.getLog().getMessage();
                if (commitMessage.endsWith("\n")) {
                    commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
                }
                sd.insertString(sd.getLength(), "\n", null);
                sd.insertString(sd.getLength(), commitMessage, null);
                if (SummaryView.this.message != null && !isSelected && (idx = commitMessage.indexOf(SummaryView.this.message)) != -1) {
                    int len = commitMessage.length();
                    int doclen = sd.getLength();
                    sd.setCharacterAttributes(doclen - len + idx, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                if (commitMessage != null && (width = SummaryView.this.master.getWidth()) > 0) {
                    FontMetrics fm = list.getFontMetrics(list.getFont());
                    Rectangle2D rect = fm.getStringBounds(commitMessage, this.textPane.getGraphics());
                    int nlc = -1;
                    int i = 0;
                    while (i != -1) {
                        i = commitMessage.indexOf(10, i + 1);
                        ++nlc;
                    }
                    int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                    int ph = fm.getHeight() * (lines + ++nlc) + 0;
                    this.textPane.setPreferredSize(new Dimension(width - 50, ph));
                }
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.actionsPane.setVisible(true);
            this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), foregroundColor, backgroundColor);
            this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), foregroundColor, backgroundColor);
        }

        private void renderRevision(JList list, RepositoryRevision.Event dispRevision, int index, boolean isSelected) {
            Style style;
            Color backgroundColor;
            StyledDocument sd = this.textPane.getStyledDocument();
            if (isSelected) {
                Color foregroundColor = UIManager.getColor("List.selectionForeground");
                backgroundColor = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                Color foregroundColor = UIManager.getColor("List.foreground");
                backgroundColor = UIManager.getColor("List.background");
                style = this.normalStyle;
            }
            this.textPane.setBackground(backgroundColor);
            this.actionsPane.setVisible(false);
            this.index = -1;
            try {
                sd.remove(0, sd.getLength());
                sd.setParagraphAttributes(0, sd.getLength(), this.indentStyle, false);
                sd.insertString(sd.getLength(), String.valueOf(dispRevision.getChangedPath().getAction()), null);
                sd.insertString(sd.getLength(), FIELDS_SEPARATOR + dispRevision.getChangedPath().getPath(), null);
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.index == -1) {
                return;
            }
            Rectangle apb = this.actionsPane.getBounds();
            Rectangle bounds = this.diffLink.getBounds();
            bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
            SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, bounds);
            bounds = this.revertLink.getBounds();
            bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, bounds);
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

