/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.ignore;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreAction
extends ContextAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes);
        switch (actionStatus) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 6;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 6;
    }

    public int getActionStatus(Node[] nodes) {
        return this.getActionStatus(SvnUtils.getCurrentContext(nodes).getFiles());
    }

    public int getActionStatus(File[] files) {
        int actionStatus = -1;
        if (files.length == 0) {
            return 0;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".svn") || files[i].getName().equals("_svn")) {
                actionStatus = 0;
                break;
            }
            FileInformation info = cache.getStatus(files[i]);
            if (info.getStatus() == 4) {
                if (actionStatus == 2) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 1;
                continue;
            }
            if (info.getStatus() == 2) {
                if (actionStatus == 1) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 2;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return this.getActionStatus(nodes) != 0;
    }

    @Override
    public void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        final int actionStatus = this.getActionStatus(nodes);
        if (actionStatus != 1 && actionStatus != 2) {
            throw new RuntimeException("Invalid action status: " + actionStatus);
        }
        final File[] files = SvnUtils.getCurrentContext(nodes).getRootFiles();
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

            public void perform() {
                SvnClient client;
                Map names = IgnoreAction.this.splitByParent(files);
                try {
                    client = Subversion.getInstance().getClient(false);
                }
                catch (SVNClientException e) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
                    return;
                }
                for (File parent : names.keySet()) {
                    Set patterns = (Set)names.get(parent);
                    if (this.isCanceled()) {
                        return;
                    }
                    try {
                        HashSet currentPatterns = new HashSet(client.getIgnoredPatterns(parent));
                        if (actionStatus == 1) {
                            IgnoreAction.ensureVersioned(parent);
                            currentPatterns.addAll(patterns);
                        } else if (actionStatus == 2) {
                            currentPatterns.removeAll(patterns);
                        }
                        client.setIgnoredPatterns(parent, new ArrayList(currentPatterns));
                    }
                    catch (SVNClientException e) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
                    }
                }
                for (File file : files) {
                    Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                for (File parent : names.keySet()) {
                    Subversion.getInstance().getStatusCache().refresh(parent, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }

    private Map<File, Set<String>> splitByParent(File[] files) {
        HashMap<File, Set<String>> map = new HashMap<File, Set<String>>(2);
        for (File file : files) {
            File parent = file.getParentFile();
            if (parent == null) continue;
            HashSet<String> names = (HashSet<String>)map.get(parent);
            if (names == null) {
                names = new HashSet<String>(5);
                map.put(parent, names);
            }
            names.add(file.getName());
        }
        return map;
    }

    private static void ensureVersioned(File file) throws SVNClientException {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if ((cache.getStatus(file).getStatus() & 0x1DF8) != 0) {
            return;
        }
        IgnoreAction.ensureVersioned(file.getParentFile());
        IgnoreAction.add(file);
        cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private static void add(File file) throws SVNClientException {
        SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(file);
        SvnClient client = Subversion.getInstance().getClient(repositoryUrl);
        client.addFile(file);
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ignore(File file) throws SVNClientException {
        Class<IgnoreAction> clazz = IgnoreAction.class;
        synchronized (IgnoreAction.class) {
            File parent = file.getParentFile();
            IgnoreAction.ensureVersioned(parent);
            List patterns = Subversion.getInstance().getClient(true).getIgnoredPatterns(parent);
            if (!patterns.contains(file.getName())) {
                patterns.add(file.getName());
                Subversion.getInstance().getClient(true).setIgnoredPatterns(parent, patterns);
            }
            Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

