/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnProperties
implements ActionListener,
DocumentListener {
    private PropertiesPanel panel;
    private File root;
    private PropertiesTable propTable;
    private SvnProgressSupport support;
    private boolean loadedFromFile;
    private File loadedValueFile;
    private Font fontTextArea;

    public SvnProperties(PropertiesPanel panel, PropertiesTable propTable, File root) {
        this.panel = panel;
        this.propTable = propTable;
        this.root = root;
        panel.txtAreaValue.getDocument().addDocumentListener(this);
        ((JTextField)panel.comboName.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        propTable.getTable().addMouseListener(new TableMouseListener());
        panel.btnRefresh.addActionListener(this);
        panel.btnAdd.addActionListener(this);
        panel.btnRemove.addActionListener(this);
        panel.btnBrowse.addActionListener(this);
        panel.comboName.setEditable(true);
        if (!root.isDirectory()) {
            panel.cbxRecursively.setEnabled(false);
        }
        this.setLoadedValueFile(null);
        this.initPropertyNameCbx();
        this.setLoadedFromFile(false);
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel panel) {
        this.panel = panel;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public void setLoadedValueFile(File file) {
        this.loadedValueFile = file;
    }

    public File getLoadedValueFile() {
        return this.loadedValueFile;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.panel.btnRefresh)) {
            this.refreshProperties();
        }
        if (source.equals(this.panel.btnAdd)) {
            this.setProperties();
        }
        if (source.equals(this.panel.btnRemove)) {
            this.removeProperties();
        }
        if (source.equals(this.panel.btnBrowse)) {
            this.loadFromFile();
        }
    }

    protected void initPropertyNameCbx() {
        ArrayList<String> lstName = new ArrayList<String>(8);
        if (this.panel.comboName.isEditable()) {
            if (this.root.isDirectory()) {
                lstName.add("svn:ignore");
                lstName.add("svn:externals");
            } else {
                lstName.add("svn:eol-style");
                lstName.add("svn:executable");
                lstName.add("svn:keywords");
                lstName.add("svn:needs-lock");
                lstName.add("svn:mime-type");
            }
        }
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel(new Vector(lstName));
        this.panel.comboName.setModel(comboModel);
        this.panel.comboName.getEditor().setItem("");
    }

    protected String getPropertyValue() {
        return this.panel.txtAreaValue.getText();
    }

    protected String getPropertyName() {
        Object selectedItem = this.panel.comboName.getSelectedObjects()[0];
        if (selectedItem != null) {
            return this.panel.comboName.getEditor().getItem().toString().trim();
        }
        return selectedItem.toString().trim();
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(boolean value) {
        this.loadedFromFile = value;
    }

    public void handleBinaryFile(File source) {
        this.setLoadedValueFile(source);
        StringBuffer txtValue = new StringBuffer();
        txtValue.append(NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content"));
        txtValue.append("\n");
        try {
            txtValue.append(source.getCanonicalPath());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        this.fontTextArea = this.panel.txtAreaValue.getFont();
        this.panel.txtAreaValue.setFont(new Font("Monospaced", 2, 12));
        this.panel.txtAreaValue.setText(txtValue.toString());
        this.setLoadedFromFile(true);
    }

    public void loadFromFile() {
        AccessibleJFileChooser chooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnProperties.class, (String)"ACSD_Properties"));
        chooser.setDialogTitle(NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilters = chooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilters.length; ++i) {
            FileFilter fileFilter = fileFilters[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.setCurrentDirectory(this.root.getParentFile());
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.exists();
            }

            public String getDescription() {
                return "";
            }
        });
        chooser.setDialogType(0);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(SvnProperties.class, (String)"MNE_LoadValue").charAt(0));
        chooser.setApproveButtonText(NbBundle.getMessage(SvnProperties.class, (String)"CTL_LoadValue"));
        DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        dd.setOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        chooser.addActionListener(new ActionListener((JFileChooser)chooser, dialog){
            final /* synthetic */ JFileChooser val$chooser;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$chooser = jFileChooser;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    File source = this.val$chooser.getSelectedFile();
                    if (SvnUtils.isFileContentBinary(source)) {
                        SvnProperties.this.handleBinaryFile(source);
                    } else if (source.canRead()) {
                        StringWriter sw = new StringWriter();
                        try {
                            Utils.copyStreamsCloseAll((Writer)sw, (Reader)new FileReader(source));
                            ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(sw.toString());
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
                this.val$dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                ISVNProperty[] isvnProps;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    try {
                        this.isvnProps = this.client.getProperties(SvnProperties.this.root);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SvnPropertiesNode[] svnProps = new SvnPropertiesNode[isvnProps.length];
                            for (int i = 0; i < isvnProps.length; ++i) {
                                String tmp;
                                if (isvnProps[i] == null) {
                                    return;
                                }
                                String name = isvnProps[i].getName();
                                String value = SvnUtils.isBinary(isvnProps[i].getData()) ? NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content") : ((tmp = isvnProps[i].getValue()) != null ? tmp : "");
                                svnProps[i] = new SvnPropertiesNode(name, value);
                            }
                            SvnProperties.this.propTable.setNodes(svnProps);
                        }
                    });
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                ISVNProperty[] isvnProps;

                protected void perform() {
                    block7: {
                        try {
                            this.client = Subversion.getInstance().getClient(repositoryUrl);
                        }
                        catch (SVNClientException ex) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                            return;
                        }
                        try {
                            if (SvnProperties.this.isLoadedFromFile()) {
                                try {
                                    this.client.propertySet(SvnProperties.this.root, SvnProperties.this.getPropertyName(), SvnProperties.this.getLoadedValueFile(), ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected());
                                    break block7;
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify((Throwable)ex);
                                    return;
                                }
                            }
                            this.client.propertySet(SvnProperties.this.root, SvnProperties.this.getPropertyName(), SvnProperties.this.getPropertyValue(), ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected());
                        }
                        catch (SVNClientException ex) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                            return;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem("");
                            ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                        }
                    });
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final int[] rows = this.propTable.getSelectedItems();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    try {
                        boolean recursively = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                        for (int i = rows.length - 1; i >= 0; --i) {
                            SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                            List<SvnPropertiesNode> lstSvnPropertiesNodes = Arrays.asList(svnPropertiesNodes);
                            String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])].getName();
                            this.client.propertyDel(SvnProperties.this.root, svnPropertyName, recursively);
                            try {
                                lstSvnPropertiesNodes.remove(svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])]);
                            }
                            catch (UnsupportedOperationException e) {
                                // empty catch block
                            }
                            SvnProperties.this.propTable.setNodes((SvnPropertiesNode[])lstSvnPropertiesNodes.toArray());
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    public void insertUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    public void changedUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUserInput(DocumentEvent event) {
        Document doc = event.getDocument();
        JTextArea jTextArea = this.panel.txtAreaValue;
        synchronized (jTextArea) {
            if (doc.equals(this.panel.txtAreaValue.getDocument()) && this.isLoadedFromFile()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setFont(SvnProperties.this.fontTextArea);
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                    }
                });
                this.setLoadedFromFile(false);
            }
        }
        String name = this.panel.comboName.getEditor().getItem().toString().trim();
        String value = this.panel.txtAreaValue.getText().trim();
        if (name.length() == 0 || value.length() == 0 || name.indexOf(" ") > 0) {
            this.panel.btnAdd.setEnabled(false);
        } else {
            this.panel.btnAdd.setEnabled(true);
        }
    }

    public class TableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                int[] rows = SvnProperties.this.propTable.getSelectedItems();
                SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                if (svnPropertiesNodes == null) {
                    return;
                }
                final String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getName();
                final String svnPropertyValue = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getValue();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem(svnPropertyName);
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(svnPropertyValue);
                    }
                });
            }
        }
    }
}

