/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.relocate;

import java.awt.Dialog;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.relocate.RelocatePanel;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RelocateAction
extends ContextAction {
    SvnProgressSupport support;

    protected boolean enable(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        File[] roots = ctx.getRootFiles();
        if (roots == null || roots.length != 1) {
            return false;
        }
        File file = roots[0];
        return file != null && file.isDirectory();
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    private String getCurrentURL(File root) {
        try {
            SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(root);
            return repositoryUrl.toString();
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return "";
        }
    }

    private String getWorkingCopy(File root) {
        String working = root.getAbsolutePath();
        return working;
    }

    public void validate(RelocatePanel panel, JButton btnOk) {
        try {
            new SVNUrl(panel.getNewURL().getText());
            btnOk.setEnabled(true);
        }
        catch (MalformedURLException e) {
            btnOk.setEnabled(false);
        }
    }

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Relocate_Title";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performContextAction(Node[] nodes) {
        SVNUrl repositoryUrl;
        ResourceBundle loc = NbBundle.getBundle(RelocateAction.class);
        Context ctx = this.getContext(nodes);
        File[] roots = ctx.getRootFiles();
        if (roots == null) {
            return;
        }
        final RelocatePanel panel = new RelocatePanel();
        panel.getCurrentURL().setText(this.getCurrentURL(roots[0]));
        panel.getWorkingCopy().setText(this.getWorkingCopy(roots[0]));
        final JButton btnRelocate = new JButton(loc.getString("CTL_Relocate_Action_Name"));
        btnRelocate.setEnabled(false);
        btnRelocate.setToolTipText(loc.getString("TT_Relocate_Action"));
        panel.getNewURL().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }

            public void removeUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }

            public void changedUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }
        });
        JButton btnCancel = new JButton(loc.getString("CTL_Relocate_Action_Cancel"));
        btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelocateAction.class, (String)"ACSD_Relocate_Action_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, loc.getString("CTL_Relocate_Title"), true, new Object[]{btnRelocate, btnCancel}, (Object)btnRelocate, 0, null, null);
        descriptor.setClosingOptions(null);
        descriptor.setHelpCtx(new HelpCtx(RelocateAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(loc.getString("ACSD_Relocate"));
        dialog.setVisible(true);
        if (descriptor.getValue() != btnRelocate) {
            return;
        }
        final String newUrl = panel.getNewURL().getText();
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final String wc = roots[0].getAbsolutePath();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client = null;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                        this.client.relocate(repositoryUrl.toString(), newUrl, wc, true);
                    }
                    catch (SVNClientException ex) {
                        RelocateAction.this.support.annotate(ex);
                    }
                }
            };
            this.support.start(rp, repositoryUrl, loc.getString("LBL_Relocate_Progress"));
        }
        finally {
            this.support = null;
        }
    }
}

