/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.update.RevertModificationsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RevertModifications
implements PropertyChangeListener {
    private RevertModificationsPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private RevertType[] types;

    public RevertModifications(RepositoryFile repositoryFile) {
        this(repositoryFile, null);
    }

    public RevertModifications(RepositoryFile repositoryFile, String defaultRevision) {
        OneCommitRevertType ocrt = new OneCommitRevertType(repositoryFile, this.getPanel().oneCommitRadioButton);
        this.types = new RevertType[]{new LocalRevertType(this.getPanel().localChangesRadioButton), ocrt, new MoreCommitsRevertType(repositoryFile, this.getPanel().moreCommitsRadioButton)};
        this.okButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Revert"));
        this.cancelButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Cancel"));
        if (defaultRevision != null) {
            this.panel.oneCommitRadioButton.setSelected(true);
            this.panel.oneRevisionTextField.setText(defaultRevision);
            ocrt.actionPerformed(null);
        }
    }

    private RevertModificationsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new RevertModificationsPanel();
        }
        return this.panel;
    }

    RevisionInterval getRevisionInterval() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].getRevisionInterval();
        }
        return null;
    }

    boolean revertNewFiles() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].revertNewFiles();
        }
        return false;
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertDialog"));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertDialog"));
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid") && this.okButton != null) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    protected void setMoreCommitsFieldsEnabled(boolean b) {
        this.getPanel().startRevisionTextField.setEnabled(b);
        this.getPanel().endRevisionTextField.setEnabled(b);
        this.getPanel().startSearchButton.setEnabled(b);
        this.getPanel().endSearchButton.setEnabled(b);
    }

    protected void setOneCommitFieldsEnabled(boolean b) {
        this.getPanel().oneRevisionSearchButton.setEnabled(b);
        this.getPanel().oneRevisionTextField.setEnabled(b);
    }

    private class LocalRevertType
    extends RevertType {
        LocalRevertType(JRadioButton button) {
            super(button);
        }

        RevisionInterval getRevisionInterval() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
        }
    }

    private class MoreCommitsRevertType
    extends RevertType {
        private RepositoryPaths endPath;
        private RepositoryPaths startPath;

        MoreCommitsRevertType(RepositoryFile repositoryFile, JRadioButton button) {
            super(button);
            this.startPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().startRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().startSearchButton);
            this.startPath.addPropertyChangeListener(RevertModifications.this);
            this.endPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().endRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().endSearchButton);
            this.endPath.addPropertyChangeListener(RevertModifications.this);
        }

        RevisionInterval getRevisionInterval() {
            SVNRevision revision1 = this.getRevision(this.startPath);
            SVNRevision revision2 = this.getRevision(this.endPath);
            if (revision1 == null || revision2 == null) {
                return null;
            }
            return this.getResortedRevisionInterval(revision1, revision2);
        }

        void validateUserInput() {
            if (!this.validateRevision(this.getRevision(this.startPath))) {
                return;
            }
            if (!this.validateRevision(this.getRevision(this.endPath))) {
                return;
            }
        }

        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setMoreCommitsFieldsEnabled(true);
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            this.validateUserInput();
        }

        private RevisionInterval getResortedRevisionInterval(SVNRevision revision1, SVNRevision revision2) {
            RevisionInterval ret = new RevisionInterval();
            if (revision1.equals((Object)SVNRevision.HEAD) && revision1.equals((Object)SVNRevision.HEAD)) {
                ret.startRevision = revision1;
                ret.endRevision = revision2;
            } else if (revision1.equals((Object)SVNRevision.HEAD)) {
                ret.startRevision = revision2;
                ret.endRevision = revision1;
            } else if (revision2.equals((Object)SVNRevision.HEAD)) {
                ret.startRevision = revision1;
                ret.endRevision = revision2;
            } else {
                Long r2;
                Long r1 = Long.parseLong(revision1.toString());
                if (r1.compareTo(r2 = Long.valueOf(Long.parseLong(revision2.toString()))) < 0) {
                    ret.startRevision = revision1;
                    ret.endRevision = revision2;
                } else {
                    ret.startRevision = revision2;
                    ret.endRevision = revision1;
                }
            }
            return ret;
        }
    }

    private class OneCommitRevertType
    extends RevertType {
        private RepositoryPaths oneRevisionPath;

        OneCommitRevertType(RepositoryFile repositoryFile, JRadioButton button) {
            super(button);
            this.oneRevisionPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionSearchButton);
            this.oneRevisionPath.addPropertyChangeListener(RevertModifications.this);
        }

        RevisionInterval getRevisionInterval() {
            SVNRevision revision = this.getRevision(this.oneRevisionPath);
            RevisionInterval ret = new RevisionInterval();
            ret.startRevision = revision;
            ret.endRevision = revision;
            return ret;
        }

        void validateUserInput() {
            this.validateRevision(this.getRevision(this.oneRevisionPath));
        }

        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setOneCommitFieldsEnabled(true);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
            this.validateUserInput();
        }
    }

    private abstract class RevertType
    implements ActionListener,
    DocumentListener {
        private JRadioButton button;

        RevertType(JRadioButton button) {
            this.button = button;
            button.addActionListener(this);
        }

        boolean isSelected() {
            return this.button.isSelected();
        }

        boolean revertNewFiles() {
            return ((RevertModifications)RevertModifications.this).panel.revertNewFilesCheckBox.isSelected();
        }

        public void insertUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        public void removeUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        public void changedUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        void validateUserInput() {
        }

        RevisionInterval getRevisionInterval() {
            return null;
        }

        protected SVNRevision getRevision(RepositoryPaths path) {
            try {
                return path.getRepositoryFiles()[0].getRevision();
            }
            catch (NumberFormatException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            return null;
        }

        protected boolean validateRevision(SVNRevision revision) {
            boolean valid = revision == null || revision.equals((Object)SVNRevision.HEAD) || revision.getKind() == 1;
            RevertModifications.this.okButton.setEnabled(valid);
            return valid;
        }
    }

    static class RevisionInterval {
        SVNRevision startRevision;
        SVNRevision endRevision;

        RevisionInterval() {
        }
    }
}

