/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4088;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        this.performUpdate(nodes);
    }

    private void performUpdate(Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes){

            public void perform() {
                UpdateAction.update(ctx, this);
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }

    private static void update(Context ctx, SvnProgressSupport progress) {
        SvnClient client;
        int i;
        SVNUrl repositoryUrl;
        File[] roots = ctx.getRootFiles();
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        cache.refreshCached(ctx);
        File[][] split = Utils.splitFlatOthers((File[])roots);
        ArrayList<File> recursiveFiles = new ArrayList<File>();
        ArrayList<File> flatFiles = new ArrayList<File>();
        for (i = 0; i < split[1].length; ++i) {
            recursiveFiles.add(split[1][i]);
        }
        for (i = 0; i < split[0].length; ++i) {
            flatFiles.add(split[0][i]);
        }
        try {
            client = Subversion.getInstance().getClient(repositoryUrl);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        try {
            UpdateAction.updateRoots(recursiveFiles, progress, client, true);
            if (progress.isCanceled()) {
                return;
            }
            UpdateAction.updateRoots(flatFiles, progress, client, false);
        }
        catch (SVNClientException e1) {
            progress.annotate(e1);
        }
    }

    private static void updateRoots(List<File> roots, SvnProgressSupport support, SvnClient client, boolean recursive) throws SVNClientException {
        boolean conflict = false;
        block0: for (File root : roots) {
            if (support.isCanceled()) break;
            client.update(root, SVNRevision.HEAD, recursive);
            ISVNStatus[] status = client.getStatus(root, true, false);
            for (int k = 0; k < status.length; ++k) {
                ISVNStatus s = status[k];
                if (!SVNStatusUtils.isTextConflicted((ISVNStatus)s) && !SVNStatusUtils.isPropConflicted((ISVNStatus)s)) continue;
                conflict = true;
                break block0;
            }
        }
        if (conflict) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Conflicts"));
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Completed"));
        }
    }

    public static void performUpdate(final Context context) {
        SVNUrl repository;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            repository = UpdateAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            public void perform() {
                UpdateAction.update(context, this);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }
}

