/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportPreviewStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep;
import org.netbeans.modules.subversion.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class ImportWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private ImportStep importStep;
    private ImportPreviewStep importPreviewStep;
    private String errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;
    private final Context context;

    public ImportWizard(Context context) {
        this.context = context;
    }

    public boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (!finnished) {
            if (value == WizardDescriptor.CLOSED_OPTION || value == WizardDescriptor.CANCEL_OPTION) {
                this.repositoryStep.stop();
                this.importStep.stop();
            }
        } else if (value == WizardDescriptor.FINISH_OPTION) {
            if (this.wizardIterator.current() == this.importStep) {
                this.setupImportPreviewStep();
            } else if (this.wizardIterator.current() == this.importPreviewStep) {
                this.importPreviewStep.storeTableSorter();
            }
        }
        return finnished;
    }

    private void setupImportPreviewStep() {
        String repositoryUrl = this.repositoryStep.getRepositoryFile().getRepositoryUrl().toString();
        String repositoryFolderUrl = this.importStep.getRepositoryFolderUrl().toString();
        String localPath = this.context.getRootFiles()[0].getAbsolutePath();
        this.importPreviewStep.setup(repositoryFolderUrl.substring(repositoryUrl.length()), localPath);
    }

    private void setErrorMessage(String msg) {
        this.errorMessage = msg;
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        if (step == null) {
            return;
        }
        this.setErrorMessage(step.getErrorMessage());
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryStep.getRepositoryFile().getRepositoryUrl();
    }

    public String getMessage() {
        return this.importStep.getImportMessage();
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.importStep.getRepositoryFolderUrl();
    }

    public Map getCommitFiles() {
        return this.importPreviewStep.getCommitFiles();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[3];
            ImportWizard.this.repositoryStep = new RepositoryStep();
            ImportWizard.this.repositoryStep.addChangeListener(ImportWizard.this);
            File file = ImportWizard.this.context.getRootFiles()[0];
            ImportWizard.this.importStep = new ImportStep(new BrowserAction[]{new CreateFolderAction(file.getName())}, file);
            ImportWizard.this.importStep.addChangeListener(ImportWizard.this);
            ImportWizard.this.importPreviewStep = new ImportPreviewStep(ImportWizard.this.context);
            panels = new WizardDescriptor.Panel[]{ImportWizard.this.repositoryStep, ImportWizard.this.importStep, ImportWizard.this.importPreviewStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public void previousPanel() {
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.invalid(null);
            }
            super.previousPanel();
        }

        public void nextPanel() {
            if (this.current() == ImportWizard.this.repositoryStep) {
                File file = ImportWizard.this.context.getRootFiles()[0];
                ImportWizard.this.importStep.setup(ImportWizard.this.repositoryStep.getRepositoryFile().appendPath(file.getName()));
            } else if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.setupImportPreviewStep();
            }
            super.nextPanel();
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.validateUserInput();
            }
        }
    }
}

