/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.checkoutstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutStep
extends AbstractStep
implements ActionListener,
DocumentListener,
FocusListener {
    public static final String CHECKOUT_DIRECTORY = "checkoutStep.checkoutDirectory";
    private CheckoutPanel workdirPanel;
    private RepositoryPaths repositoryPaths;

    public HelpCtx getHelp() {
        return new HelpCtx(CheckoutStep.class);
    }

    protected JComponent createComponent() {
        if (this.workdirPanel == null) {
            this.workdirPanel = new CheckoutPanel();
            this.workdirPanel.browseWorkdirButton.addActionListener(this);
            this.workdirPanel.browseRepositoryButton.addActionListener(this);
            this.workdirPanel.scanForProjectsCheckBox.addActionListener(this);
            this.workdirPanel.workdirTextField.setText(this.defaultWorkingDirectory().getPath());
            this.workdirPanel.workdirTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.workdirTextField.addFocusListener(this);
            this.workdirPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.repositoryPathTextField.addFocusListener(this);
            this.workdirPanel.revisionTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.revisionTextField.addFocusListener(this);
        }
        this.validateUserInput(true);
        return this.workdirPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.workdirPanel.repositoryPathTextField, this.workdirPanel.browseRepositoryButton, this.workdirPanel.revisionTextField, this.workdirPanel.searchRevisionButton);
            String browserPurposeMessage = NbBundle.getMessage(CheckoutStep.class, (String)"LBL_BrowserMessage");
            int browserMode = 9;
            this.repositoryPaths.setupBrowserBehavior(browserPurposeMessage, browserMode);
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.workdirPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        if (!repositoryFile.getRevision().equals((Object)SVNRevision.HEAD)) {
            this.workdirPanel.revisionTextField.setText(repositoryFile.getRevision().toString());
        } else {
            this.workdirPanel.revisionTextField.setText("");
        }
        this.workdirPanel.scanForProjectsCheckBox.setSelected(SvnModuleConfig.getDefault().getShowCheckoutCompleted());
    }

    protected void validateBeforeNext() {
        boolean done;
        String text;
        File file;
        if (this.validateUserInput(true) && !(file = new File(text = this.workdirPanel.workdirTextField.getText())).exists() && !(done = file.mkdirs())) {
            this.invalid(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2013") + file.getPath());
        }
    }

    private boolean validateUserInput(boolean full) {
        String text;
        if (this.repositoryPaths != null) {
            try {
                this.repositoryPaths.getRepositoryFiles();
            }
            catch (NumberFormatException ex) {
                this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2018"));
                return false;
            }
            catch (MalformedURLException ex) {
                this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2015"));
                return false;
            }
        }
        if ((text = this.workdirPanel.workdirTextField.getText()) == null || text.length() == 0) {
            this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2014"));
            return false;
        }
        String errorMessage = null;
        if (full) {
            File file = new File(text);
            if (!file.exists()) {
                for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (!parent.exists()) continue;
                    if (!parent.canWrite()) {
                        errorMessage = NbBundle.getMessage(CheckoutStep.class, (String)"BK2016") + parent.getPath();
                    }
                    break;
                }
            } else if (file.isFile()) {
                errorMessage = NbBundle.getMessage(CheckoutStep.class, (String)"BK2017");
            }
        }
        if (errorMessage == null) {
            this.valid();
        } else {
            this.invalid(errorMessage);
        }
        return errorMessage == null;
    }

    private void onBrowseWorkdir() {
        File defaultDir = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CheckoutStep.class, (String)"ACSD_BrowseFolder"), defaultDir);
        fileChooser.setDialogTitle(NbBundle.getMessage(CheckoutStep.class, (String)"BK0010"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(CheckoutStep.class, (String)"BK0008");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.workdirPanel, NbBundle.getMessage(CheckoutStep.class, (String)"BK0009"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.workdirPanel.workdirTextField.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        String coDir;
        File defaultDir = null;
        String current = this.workdirPanel.workdirTextField.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (coDir = SvnModuleConfig.getDefault().getPreferences().get(CHECKOUT_DIRECTORY, null)) != null) {
            defaultDir = new File(coDir);
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput(false);
        this.refreshSkipLabel();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput(false);
        this.refreshSkipLabel();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.validateUserInput(true);
        this.refreshSkipLabel();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.workdirPanel.browseWorkdirButton) {
            this.onBrowseWorkdir();
        } else if (e.getSource() == this.workdirPanel.scanForProjectsCheckBox) {
            SvnModuleConfig.getDefault().setShowCheckoutCompleted(this.workdirPanel.scanForProjectsCheckBox.isSelected());
        }
    }

    public File getWorkdir() {
        return new File(this.workdirPanel.workdirTextField.getText());
    }

    public RepositoryFile[] getRepositoryFiles() {
        try {
            return this.repositoryPaths.getRepositoryFiles(".");
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public boolean isAtWorkingDirLevel() {
        return this.workdirPanel.atWorkingDirLevelCheckBox.isSelected();
    }

    private void refreshSkipLabel() {
        if (this.workdirPanel.repositoryPathTextField.getText().trim().equals("")) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        RepositoryFile[] repositoryFiles = null;
        try {
            repositoryFiles = this.repositoryPaths.getRepositoryFiles();
        }
        catch (NumberFormatException ex) {
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (repositoryFiles == null || repositoryFiles.length > 1) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        String repositoryFolder = repositoryFiles[0].getFileUrl().getLastPathSegment().trim();
        if (repositoryFolder.equals("") || repositoryFolder.equals(".")) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentFolder", (Object[])new Object[]{repositoryFolder}));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(true);
    }

    private void resetWorkingDirLevelCheckBox() {
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentEmpty"));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(false);
    }
}

