/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.PreviewPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportPreviewStep
extends AbstractStep {
    private PreviewPanel previewPanel;
    private Context context;
    private CommitTable table;

    public ImportPreviewStep(Context context) {
        this.context = context;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportStep.class);
    }

    protected JComponent createComponent() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel();
            this.table = new CommitTable(this.previewPanel.tableLabel, CommitTable.IMPORT_COLUMNS, new String[]{"path"});
            JComponent component = this.table.getComponent();
            this.previewPanel.tablePanel.setLayout(new BorderLayout());
            this.previewPanel.tablePanel.add((Component)component, "Center");
        }
        return this.previewPanel;
    }

    protected void validateBeforeNext() {
        this.validateUserInput();
    }

    public void validateUserInput() {
        if (this.table != null && this.table.getCommitFiles().size() > 0) {
            this.valid();
        } else {
            this.invalid(NbBundle.getMessage(ImportPreviewStep.class, (String)"CTL_Import_NothingToImport"));
        }
    }

    public void setup(String repositoryPath, String rootLocalPath) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = cache.listFiles(this.context, 6612);
        if (files.length == 0) {
            return;
        }
        if (repositoryPath != null) {
            this.table.setRootFile(repositoryPath, rootLocalPath);
        }
        ArrayList<SvnFileNode> nodesList = new ArrayList<SvnFileNode>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            SvnFileNode node = new SvnFileNode(file);
            nodesList.add(node);
        }
        SvnFileNode[] nodes = nodesList.toArray(new SvnFileNode[files.length]);
        this.table.setNodes(nodes);
        this.validateUserInput();
    }

    public Map getCommitFiles() {
        return this.table.getCommitFiles();
    }

    public void storeTableSorter() {
    }
}

