/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.event.FocusEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportPanel;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ImportStep
extends AbstractStep
implements DocumentListener,
WizardDescriptor.AsynchronousValidatingPanel,
WizardDescriptor.FinishablePanel {
    private ImportPanel importPanel;
    private RepositoryPaths repositoryPaths;
    private BrowserAction[] actions;
    private File importDirectory;
    private WizardStepProgressSupport support;

    public ImportStep(BrowserAction[] actions, File importDirectory) {
        this.actions = actions;
        this.importDirectory = importDirectory;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportStep.class);
    }

    protected JComponent createComponent() {
        if (this.importPanel == null) {
            this.importPanel = new ImportPanel();
            this.importPanel.messageTextArea.getDocument().addDocumentListener(this);
            this.importPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
        }
        return this.importPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            this.support = new ImportProgressSupport(this.importPanel.progressPanel, this.importPanel.progressLabel);
            SVNUrl url = this.getUrl();
            this.support.setRepositoryRoot(url);
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
            RequestProcessor.Task task = this.support.start(rp, url, NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_Progress"));
            task.waitFinished();
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        RepositoryFile repositoryFile = this.getRepositoryFile();
        return repositoryFile.getRepositoryUrl();
    }

    public boolean validateUserInput() {
        boolean valid;
        this.invalid(null);
        String text = this.importPanel.repositoryPathTextField.getText().trim();
        if (text.length() == 0) {
            this.invalid(NbBundle.getMessage(ImportStep.class, (String)"BK2014"));
            return false;
        }
        text = this.importPanel.messageTextArea.getText().trim();
        boolean bl = valid = text.length() > 0;
        if (valid) {
            this.valid();
        } else {
            this.invalid(NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_MessageRequired"));
        }
        return valid;
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.validateUserInput();
    }

    public String getImportMessage() {
        return this.importPanel.messageTextArea.getText();
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.importPanel.repositoryPathTextField.getText().trim().equals("")) {
            if (this.repositoryPaths == null) {
                this.repositoryPaths = new RepositoryPaths(repositoryFile, this.importPanel.repositoryPathTextField, this.importPanel.browseRepositoryButton, null, null);
                String browserPurposeMessage = NbBundle.getMessage(ImportStep.class, (String)"LBL_BrowserMessage");
                int browserMode = 2;
                this.repositoryPaths.setupBrowserBehavior(browserPurposeMessage, browserMode, this.actions);
            } else {
                this.repositoryPaths.setRepositoryFile(repositoryFile);
            }
        }
        this.importPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.validateUserInput();
    }

    public RepositoryFile getRepositoryFile() {
        try {
            return this.repositoryPaths.getRepositoryFiles()[0];
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.getRepositoryFile().getFileUrl();
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public boolean isFinishPanel() {
        return true;
    }

    private static void forceStatusRefresh(File file) {
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        if (!file.isFile()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ImportStep.forceStatusRefresh(files[i]);
            }
        }
    }

    private class ImportProgressSupport
    extends WizardStepProgressSupport {
        public ImportProgressSupport(JPanel panel, JLabel label) {
            super(panel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void perform() {
            String invalidMsg;
            block39: {
                block38: {
                    SVNUrl repositoryUrl;
                    RepositoryFile repositoryFile;
                    SvnClient client;
                    block37: {
                        block36: {
                            block35: {
                                invalidMsg = null;
                                try {
                                    if (ImportStep.this.validateUserInput()) break block35;
                                    Subversion.getInstance().versionedFilesChanged();
                                }
                                catch (Throwable throwable) {
                                    Subversion.getInstance().versionedFilesChanged();
                                    if (this.isCanceled()) {
                                        ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                    } else if (invalidMsg != null) {
                                        ImportStep.this.valid(invalidMsg);
                                    } else {
                                        ImportStep.this.valid();
                                    }
                                    throw throwable;
                                }
                                if (this.isCanceled()) {
                                    ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                } else if (invalidMsg != null) {
                                    ImportStep.this.valid(invalidMsg);
                                } else {
                                    ImportStep.this.valid();
                                }
                                return;
                            }
                            ImportStep.this.invalid(null);
                            try {
                                client = Subversion.getInstance().getClient(ImportStep.this.repositoryPaths.getRepositoryUrl(), (SvnProgressSupport)this);
                            }
                            catch (SVNClientException ex) {
                                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                                invalidMsg = SvnClientExceptionHandler.parseExceptionMessage(ex);
                                Subversion.getInstance().versionedFilesChanged();
                                if (this.isCanceled()) {
                                    ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                } else if (invalidMsg != null) {
                                    ImportStep.this.valid(invalidMsg);
                                } else {
                                    ImportStep.this.valid();
                                }
                                return;
                            }
                            repositoryFile = ImportStep.this.getRepositoryFile();
                            repositoryUrl = repositoryFile.getRepositoryUrl();
                            try {
                                FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + ".svn"));
                                FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + "_svn"));
                                File importDummyFolder = new File(System.getProperty("java.io.tmpdir") + "/svn_dummy/" + ImportStep.this.importDirectory.getName());
                                importDummyFolder.mkdirs();
                                importDummyFolder.deleteOnExit();
                                client.doImport(importDummyFolder, repositoryFile.getFileUrl(), ImportStep.this.getImportMessage(), false);
                            }
                            catch (SVNClientException ex) {
                                if (SvnClientExceptionHandler.isFileAlreadyExists(ex.getMessage())) break block36;
                                throw ex;
                            }
                        }
                        if (!this.isCanceled()) break block37;
                        Subversion.getInstance().versionedFilesChanged();
                        if (this.isCanceled()) {
                            ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                        } else if (invalidMsg != null) {
                            ImportStep.this.valid(invalidMsg);
                        } else {
                            ImportStep.this.valid();
                        }
                        return;
                    }
                    RepositoryFile[] repositoryFiles = new RepositoryFile[]{repositoryFile};
                    CheckoutAction.checkout(client, repositoryUrl, repositoryFiles, ImportStep.this.importDirectory, true, this);
                    Subversion.getInstance().versionedFilesChanged();
                    SvnUtils.refreshRecursively(ImportStep.this.importDirectory);
                    ImportStep.forceStatusRefresh(ImportStep.this.importDirectory);
                    if (!this.isCanceled()) break block38;
                    FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + ".svn"));
                    FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + "_svn"));
                    Subversion.getInstance().versionedFilesChanged();
                    if (this.isCanceled()) {
                        ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                    } else if (invalidMsg != null) {
                        ImportStep.this.valid(invalidMsg);
                    } else {
                        ImportStep.this.valid();
                    }
                    return;
                }
                break block39;
                catch (SVNClientException ex) {
                    this.annotate(ex);
                    invalidMsg = SvnClientExceptionHandler.parseExceptionMessage(ex);
                }
            }
            Subversion.getInstance().versionedFilesChanged();
            if (this.isCanceled()) {
                ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
            } else if (invalidMsg != null) {
                ImportStep.this.valid(invalidMsg);
            } else {
                ImportStep.this.valid();
            }
        }

        public void setEditable(boolean editable) {
            ((ImportStep)ImportStep.this).importPanel.browseRepositoryButton.setEnabled(editable);
            ((ImportStep)ImportStep.this).importPanel.messageTextArea.setEditable(editable);
            ((ImportStep)ImportStep.this).importPanel.repositoryPathTextField.setEditable(editable);
        }

        private void deleteDirectory(File file) {
            File[] files = file.listFiles();
            if (files != null || files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.deleteDirectory(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
            file.delete();
        }
    }
}

