/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Serializable {
    public static final Context Empty = new Context(Context.getEmptyList(), Context.getEmptyList(), Context.getEmptyList());
    private static final long serialVersionUID = 1L;
    private final List<File> filteredFiles;
    private final List<File> rootFiles;
    private final List<File> exclusions;

    public Context(List<File> filteredFiles, List<File> rootFiles, List<File> exclusions) {
        this.filteredFiles = filteredFiles;
        this.rootFiles = rootFiles;
        this.exclusions = exclusions;
        while (this.normalize()) {
        }
    }

    public Context(File file) {
        this(new File[]{file});
    }

    public Context(File[] files) {
        ArrayList<File> list = new ArrayList<File>(files.length);
        list.addAll(Arrays.asList(files));
        this.removeDuplicates(list);
        this.filteredFiles = list;
        this.rootFiles = list;
        this.exclusions = Collections.emptyList();
    }

    private boolean normalize() {
        for (File root : this.rootFiles) {
            Iterator<File> j = this.exclusions.iterator();
            while (j.hasNext()) {
                File exclusion = j.next();
                if (!SvnUtils.isParentOrEqual(exclusion, root)) continue;
                j.remove();
                this.exclusionRemoved(exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(List<File> files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        block0: for (File file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                File includedFile = (File)j.next();
                if (SvnUtils.isParentOrEqual(includedFile, file) && (file.isFile() || !VersioningSupport.isFlat((File)includedFile))) continue block0;
                if (!SvnUtils.isParentOrEqual(file, includedFile) || !includedFile.isFile() && VersioningSupport.isFlat((File)file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    private void exclusionRemoved(File exclusion, File root) {
        File[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            File child = exclusionChildren[i];
            if (SvnUtils.isParentOrEqual(root, child)) continue;
            this.exclusions.add(child);
        }
    }

    public List<File> getRoots() {
        return this.rootFiles;
    }

    public List<File> getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        block0: for (File root : this.rootFiles) {
            if (!SvnUtils.isParentOrEqual(root, file)) continue;
            for (File excluded : this.exclusions) {
                if (!SvnUtils.isParentOrEqual(excluded, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static final List<File> getEmptyList() {
        return Collections.emptyList();
    }
}

