/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnUtils {
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.|_)svn(\\" + File.separatorChar + ".*|$)");
    private static final FileFilter svnFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            if (Subversion.getInstance().isAdministrative(pathname)) {
                return false;
            }
            return SharabilityQuery.getSharability((File)pathname) != 2;
        }
    };

    public static Context getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        VCSContext ctx = VCSContext.forNodes((Node[])nodes);
        return new Context(new ArrayList<File>(ctx.computeFiles(svnFileFilter)), new ArrayList<File>(ctx.getRootFiles()), new ArrayList<File>(ctx.getExclusions()));
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus) {
        Context context = SvnUtils.getCurrentContext(nodes);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = context.getRootFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInformation fi = cache.getStatus(file);
            if (!(file.isDirectory() ? (fi.getStatus() & includingFolderStatus) == 0 : (fi.getStatus() & includingFileStatus) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                File f = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if ((cache.getStatus(f).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection<File> filteredFiles, Collection<File> rootFiles, Collection<File> rootFilesExclusions, Project project) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            if ((cache.getStatus(rootFile).getStatus() & 0xFFFFFFFE) == 0) continue;
            rootFiles.add(rootFile);
            boolean containsSubprojects = false;
            FileObject[] rootChildren = srcRootFo.getChildren();
            HashSet<File> projectFiles = new HashSet<File>(rootChildren.length);
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                if (Subversion.getInstance().isAdministrative(rootChildFo.getNameExt())) continue;
                File child = FileUtil.toFile((FileObject)rootChildFo);
                if (sourceGroup.contains(rootChildFo)) {
                    projectFiles.add(child);
                    continue;
                }
                int status = cache.getStatus(child).getStatus();
                if (status == 2) continue;
                rootFilesExclusions.add(child);
                containsSubprojects = true;
            }
            if (containsSubprojects) {
                filteredFiles.addAll(projectFiles);
                continue;
            }
            filteredFiles.add(rootFile);
        }
    }

    public static Context getProjectsContext(Project[] projects) {
        ArrayList<File> filtered = new ArrayList<File>();
        ArrayList<File> roots = new ArrayList<File>();
        ArrayList<File> exclusions = new ArrayList<File>();
        for (int i = 0; i < projects.length; ++i) {
            SvnUtils.addProjectFiles(filtered, roots, exclusions, projects[i]);
        }
        return new Context(filtered, roots, exclusions);
    }

    public static File[] toFileArray(Collection<FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator<FileObject> i = fileObjects.iterator();
        while (i.hasNext()) {
            files.add(FileUtil.toFile((FileObject)i.next()));
        }
        files.remove(null);
        return files.toArray(new File[files.size()]);
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static String previousRevision(String revision) {
        return revision == null ? null : Long.toString(Long.parseLong(revision) - 1L);
    }

    public static String getRelativePath(File file) throws SVNClientException {
        String repositoryPath = null;
        ArrayList<String> path = new ArrayList<String>();
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        while (Subversion.getInstance().isManaged(file)) {
            ISVNInfo info;
            block7: {
                fileIsManaged = true;
                info = null;
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block7;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && info.getUrl() != null) {
                SVNUrl fileURL = SvnUtils.decode(info.getUrl());
                repositoryURL = info.getRepository();
                if (fileURL != null && repositoryURL != null) {
                    String fileLink = fileURL.toString();
                    String repositoryLink = repositoryURL.toString();
                    repositoryPath = fileLink.substring(repositoryLink.length());
                    Iterator it = path.iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        String segment = (String)it.next();
                        sb.append("/");
                        sb.append(segment);
                    }
                    repositoryPath = repositoryPath + sb.toString();
                    break;
                }
            }
            path.add(0, file.getName());
            file = file.getParentFile();
        }
        if (repositoryURL == null & fileIsManaged) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return repositoryPath;
    }

    public static String getRelativePath(SVNUrl repositoryURL, File file) throws SVNClientException {
        SvnClient client;
        String repositoryPath = null;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        boolean fileIsManaged = false;
        while (Subversion.getInstance().isManaged(file)) {
            SVNUrl fileURL;
            ISVNStatus status;
            block8: {
                fileIsManaged = true;
                status = null;
                try {
                    status = client.getSingleStatus(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block8;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (status != null && status.getUrl() != null && (fileURL = status.getUrl()) != null && repositoryURL != null) {
                fileURL = SvnUtils.decode(fileURL);
                String fileLink = fileURL.toString();
                String repositoryLink = repositoryURL.toString();
                repositoryPath = fileLink.substring(repositoryLink.length());
                Iterator it = path.iterator();
                StringBuffer sb = new StringBuffer();
                while (it.hasNext()) {
                    String segment = (String)it.next();
                    sb.append("/");
                    sb.append(segment);
                }
                repositoryPath = repositoryPath + sb.toString();
                break;
            }
            path.add(0, file.getName());
            file = file.getParentFile();
        }
        if (repositoryURL == null & fileIsManaged) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return repositoryPath;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        while (Subversion.getInstance().isManaged(file)) {
            ISVNInfo info;
            block6: {
                fileIsManaged = true;
                info = null;
                try {
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block6;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && info.getUrl() != null && (repositoryURL = info.getRepository()) != null) break;
            file = file.getParentFile();
        }
        if (repositoryURL == null & fileIsManaged) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return repositoryURL;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuffer path = new StringBuffer();
        SVNUrl fileURL = null;
        SvnClient client = null;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        boolean fileIsManaged = false;
        while (Subversion.getInstance().isManaged(file)) {
            ISVNInfo info;
            block11: {
                block10: {
                    fileIsManaged = true;
                    try {
                        ISVNStatus status = SvnUtils.getSingleStatus(client, file);
                        if (status != null && (fileURL = SvnUtils.decode(status.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block10;
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                    }
                }
                info = null;
                try {
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block11;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && (fileURL = SvnUtils.decode(info.getUrl())) != null) break;
            path.insert(0, file.getName()).insert(0, "/");
            file = file.getParentFile();
        }
        if (fileURL == null & fileIsManaged) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (path.length() > 0) {
            fileURL = fileURL.appendPath(path.toString());
        }
        return fileURL;
    }

    private static ISVNStatus getSingleStatus(SvnClient client, File file) throws SVNClientException {
        return client.getSingleStatus(file);
    }

    private static SVNUrl decode(SVNUrl url) {
        if (url == null) {
            return null;
        }
        String s = url.toString();
        StringBuffer sb = new StringBuffer(s.length());
        boolean inQuery = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '?') {
                inQuery = true;
                continue;
            }
            if (c == '+' && inQuery) {
                sb.append(' ');
                continue;
            }
            if (SvnUtils.isEncodedByte(c, s, i)) {
                ArrayList<Byte> byteList = new ArrayList<Byte>();
                do {
                    byteList.add((byte)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                } while (SvnUtils.isEncodedByte(c = s.charAt(i += 3), s, i));
                if (byteList.size() <= 0) continue;
                byte[] bytes = new byte[byteList.size()];
                for (int ib = 0; ib < byteList.size(); ++ib) {
                    bytes[ib] = (Byte)byteList.get(ib);
                }
                try {
                    sb.append(new String(bytes, "UTF8"));
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                --i;
                continue;
            }
            sb.append(c);
        }
        try {
            return new SVNUrl(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEncodedByte(char c, String s, int i) {
        return c == '%' && i + 2 < s.length() && SvnUtils.isHexDigit(s.charAt(i + 1)) && SvnUtils.isHexDigit(s.charAt(i + 2));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl url = SvnUtils.getRepositoryUrl(file);
        SVNUrl rootUrl = SvnUtils.getRepositoryRootUrl(file);
        return SVNUrlUtils.getRelativePath((SVNUrl)rootUrl, (SVNUrl)url, (boolean)true);
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isBinary(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            byte ch = buffer[i];
            if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
            return true;
        }
        return false;
    }

    public static File[] flatten(File[] files, int status) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if ((status & info.getStatus()) != 0) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if ((status & info.getStatus()) == 0) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] getModifiedFiles(Context context, int includeStatus) {
        File[] all = Subversion.getInstance().getStatusCache().listFiles(context, includeStatus);
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            File file = all[i];
            String path = file.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(path)) continue;
            files.add(file);
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] rootFiles = context.getRootFiles();
        for (int i = 0; i < rootFiles.length; ++i) {
            File file = rootFiles[i];
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x40)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public static String getCopy(File file) {
        return SvnUtils.getCopy(file, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(File file, List<AnnotationExpression> annotationExpressions) {
        SVNUrl url;
        try {
            url = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        return SvnUtils.getCopy(url, annotationExpressions);
    }

    public static String getCopy(SVNUrl url) {
        return SvnUtils.getCopy(url, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl url, List<AnnotationExpression> annotationExpressions) {
        if (url != null) {
            for (AnnotationExpression annotationExpression : annotationExpressions) {
                Matcher m = annotationExpression.getUrlPatern().matcher(url.toString());
                if (!m.matches()) continue;
                String ae = annotationExpression.getAnnotationExp();
                StringBuffer copyName = new StringBuffer();
                StringBuffer groupStr = new StringBuffer();
                boolean inGroup = false;
                for (int i = 0; i < ae.length(); ++i) {
                    char c = ae.charAt(i);
                    if (c == '\\') {
                        inGroup = true;
                        continue;
                    }
                    if (inGroup) {
                        if (Character.isDigit(c)) {
                            groupStr.append(c);
                            continue;
                        }
                        if (groupStr.length() > 0) {
                            int group = Integer.valueOf(groupStr.toString());
                            copyName.append(m.group(group));
                            groupStr = new StringBuffer();
                        } else {
                            copyName.append('\\');
                            copyName.append(c);
                        }
                        inGroup = false;
                        continue;
                    }
                    copyName.append(c);
                }
                if (groupStr.length() > 0) {
                    int group = Integer.valueOf(groupStr.toString());
                    copyName.append(m.group(group));
                }
                return copyName.toString();
            }
        }
        return null;
    }

    public static void refreshRecursively(File folder) {
        if (folder == null) {
            return;
        }
        SvnUtils.refreshRecursively(folder.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(folder, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String host) {
        int idx = host.indexOf(64);
        if (idx < 0) {
            return host;
        }
        return host.substring(idx + 1);
    }

    public static SVNRevision getSVNRevision(String revisionString) {
        try {
            return SVNRevision.getRevision((String)revisionString);
        }
        catch (ParseException ex) {
            return new SVNRevision.Number(Long.parseLong(revisionString));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> patterns, String value, boolean onlyFirstMatch) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<String> i = patterns.iterator();
        while (i.hasNext()) {
            try {
                String patternString = i.next();
                String shellPatternString = SvnUtils.regExpToFilePatterns(patternString);
                Pattern pattern = Pattern.compile(shellPatternString);
                if (!pattern.matcher(value).matches()) continue;
                ret.add(patternString);
                if (!onlyFirstMatch) continue;
                return ret;
            }
            catch (PatternSyntaxException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return ret;
    }

    private static String regExpToFilePatterns(String exp) {
        exp = exp.replaceAll("\\.", "\\\\.");
        exp = exp.replaceAll("\\*", ".*");
        exp = exp.replaceAll("\\?", ".");
        exp = exp.replaceAll("\\$", "\\\\\\$");
        exp = exp.replaceAll("\\^", "\\\\^");
        exp = exp.replaceAll("\\<", "\\\\<");
        exp = exp.replaceAll("\\>", "\\\\>");
        exp = exp.replaceAll("\\[", "\\\\[");
        exp = exp.replaceAll("\\]", "\\\\]");
        exp = exp.replaceAll("\\{", "\\\\{");
        exp = exp.replaceAll("\\}", "\\\\}");
        exp = exp.replaceAll("\\(", "\\\\(");
        exp = exp.replaceAll("\\)", "\\\\)");
        exp = exp.replaceAll("\\+", "\\\\+");
        exp = exp.replaceAll("\\|", "\\\\|");
        return exp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation i1, FileInformation i2) {
            return SvnUtils.getComparableStatus(i1.getStatus()) - SvnUtils.getComparableStatus(i2.getStatus());
        }
    }
}

