/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.completion.CompletionLayout;

abstract class CompletionLayoutPopup {
    private CompletionLayout layout;
    private Popup popup;
    private Rectangle popupBounds;
    private JComponent contentComponent;
    private int anchorOffset;
    private Rectangle anchorOffsetBounds;
    private boolean displayAboveCaret;
    private Rectangle screenBounds;
    private boolean preferDisplayAboveCaret;
    private boolean showRetainedPreferredSize;

    CompletionLayoutPopup() {
    }

    public final boolean isVisible() {
        return this.popup != null;
    }

    public final boolean isActive() {
        return this.contentComponent != null;
    }

    public final void hide() {
        if (this.isVisible()) {
            this.popup.hide();
            this.popup = null;
            this.popupBounds = null;
            this.contentComponent = null;
            this.anchorOffset = -1;
            this.screenBounds = null;
        }
    }

    public final boolean isDisplayAboveCaret() {
        return this.displayAboveCaret;
    }

    public final Rectangle getPopupBounds() {
        return this.popupBounds;
    }

    final void setLayout(CompletionLayout layout) {
        assert (layout != null);
        this.layout = layout;
    }

    final void setPreferDisplayAboveCaret(boolean preferDisplayAboveCaret) {
        this.preferDisplayAboveCaret = preferDisplayAboveCaret;
    }

    final void setContentComponent(JComponent contentComponent) {
        assert (contentComponent != null);
        this.contentComponent = contentComponent;
    }

    final void setAnchorOffset(int anchorOffset) {
        this.anchorOffset = anchorOffset;
        this.anchorOffsetBounds = null;
    }

    final Rectangle getScreenBounds() {
        if (this.screenBounds == null) {
            JTextComponent editorComponent = this.getEditorComponent();
            GraphicsConfiguration configuration = editorComponent != null ? editorComponent.getGraphicsConfiguration() : null;
            this.screenBounds = configuration != null ? configuration.getBounds() : new Rectangle();
        }
        return this.screenBounds;
    }

    final int getAnchorOffset() {
        JTextComponent editorComponent;
        int offset = this.anchorOffset;
        if (offset == -1 && (editorComponent = this.getEditorComponent()) != null) {
            offset = editorComponent.getSelectionStart();
        }
        return offset;
    }

    final JComponent getContentComponent() {
        return this.contentComponent;
    }

    final Dimension getPreferredSize() {
        JComponent comp = this.getContentComponent();
        return comp == null ? new Dimension(0, 0) : comp.getPreferredSize();
    }

    final void resetPreferredSize() {
        JComponent comp = this.getContentComponent();
        if (comp == null) {
            return;
        }
        comp.setPreferredSize(null);
    }

    final boolean isShowRetainedPreferredSize() {
        return this.showRetainedPreferredSize;
    }

    final CompletionLayout getLayout() {
        return this.layout;
    }

    final JTextComponent getEditorComponent() {
        return this.layout.getEditorComponent();
    }

    protected int getAnchorHorizontalShift() {
        return 0;
    }

    final Rectangle getAnchorOffsetBounds() {
        JTextComponent editorComponent = this.getEditorComponent();
        if (editorComponent == null) {
            return new Rectangle();
        }
        if (this.anchorOffsetBounds == null) {
            int anchorOffset = this.getAnchorOffset();
            try {
                this.anchorOffsetBounds = editorComponent.modelToView(anchorOffset);
                if (this.anchorOffsetBounds != null) {
                    this.anchorOffsetBounds.x -= this.getAnchorHorizontalShift();
                } else {
                    this.anchorOffsetBounds = new Rectangle();
                }
            }
            catch (BadLocationException e) {
                this.anchorOffsetBounds = new Rectangle();
            }
            Point anchorOffsetPoint = this.anchorOffsetBounds.getLocation();
            SwingUtilities.convertPointToScreen(anchorOffsetPoint, editorComponent);
            this.anchorOffsetBounds.setLocation(anchorOffsetPoint);
        }
        return this.anchorOffsetBounds;
    }

    final Popup getPopup() {
        return this.popup;
    }

    private Rectangle findPopupBounds(Rectangle occupiedBounds, boolean aboveOccupiedBounds) {
        Dimension prefSize = this.getPreferredSize();
        Rectangle screen = this.getScreenBounds();
        Rectangle popupBounds = new Rectangle();
        popupBounds.x = Math.min(occupiedBounds.x, screen.x + screen.width - prefSize.width);
        popupBounds.x = Math.max(popupBounds.x, screen.x);
        popupBounds.width = Math.min(prefSize.width, screen.width);
        if (aboveOccupiedBounds) {
            popupBounds.height = Math.min(prefSize.height, occupiedBounds.y - screen.y - 1);
            popupBounds.y = occupiedBounds.y - 1 - popupBounds.height;
        } else {
            popupBounds.y = occupiedBounds.y + occupiedBounds.height + 1;
            popupBounds.height = Math.min(prefSize.height, screen.y + screen.height - popupBounds.y);
        }
        return popupBounds;
    }

    private void show(Rectangle popupBounds, boolean displayAboveCaret) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        Dimension origPrefSize = this.getPreferredSize();
        Dimension newPrefSize = popupBounds.getSize();
        JComponent contComp = this.getContentComponent();
        if (contComp == null) {
            return;
        }
        contComp.setPreferredSize(newPrefSize);
        this.showRetainedPreferredSize = newPrefSize.equals(origPrefSize);
        PopupFactory factory = PopupFactory.getSharedInstance();
        this.popup = factory.getPopup(this.layout.getEditorComponent(), contComp, popupBounds.x, popupBounds.y);
        this.popup.show();
        this.popupBounds = popupBounds;
        this.displayAboveCaret = displayAboveCaret;
    }

    void showAlongAnchorBounds() {
        this.showAlongOccupiedBounds(this.getAnchorOffsetBounds());
    }

    void showAlongAnchorBounds(boolean aboveCaret) {
        this.showAlongOccupiedBounds(this.getAnchorOffsetBounds(), aboveCaret);
    }

    void showAlongOccupiedBounds(Rectangle occupiedBounds) {
        boolean aboveCaret = this.isEnoughSpace(occupiedBounds, this.preferDisplayAboveCaret) ? this.preferDisplayAboveCaret : this.isMoreSpaceAbove(occupiedBounds);
        Rectangle bounds = this.findPopupBounds(occupiedBounds, aboveCaret);
        this.show(bounds, aboveCaret);
    }

    void showAlongOccupiedBounds(Rectangle occupiedBounds, boolean aboveCaret) {
        Rectangle bounds = this.findPopupBounds(occupiedBounds, aboveCaret);
        this.show(bounds, aboveCaret);
    }

    boolean isMoreSpaceAbove(Rectangle bounds) {
        Rectangle screen = this.getScreenBounds();
        int above = bounds.y - screen.y;
        int below = screen.y + screen.height - (bounds.y + bounds.height);
        return above > below;
    }

    boolean isEnoughSpace(Rectangle occupiedBounds) {
        return this.isEnoughSpace(occupiedBounds, this.preferDisplayAboveCaret);
    }

    boolean isEnoughSpace(Rectangle occupiedBounds, boolean aboveOccupiedBounds) {
        Rectangle screen = this.getScreenBounds();
        int freeHeight = aboveOccupiedBounds ? occupiedBounds.y - screen.y : screen.y + screen.height - (occupiedBounds.y + occupiedBounds.height);
        Dimension prefSize = this.getPreferredSize();
        return prefSize.height < freeHeight;
    }

    boolean isEnoughSpace(boolean aboveCaret) {
        return this.isEnoughSpace(this.getAnchorOffsetBounds(), aboveCaret);
    }

    public boolean isOverlapped(Rectangle bounds) {
        return this.isVisible() ? this.popupBounds.intersects(bounds) : false;
    }

    public boolean isOverlapped(CompletionLayoutPopup popup) {
        return popup.isVisible() ? this.isOverlapped(popup.getPopupBounds()) : false;
    }

    public Rectangle unionBounds(Rectangle bounds) {
        return this.isVisible() ? bounds.union(this.getPopupBounds()) : bounds;
    }

    public abstract void processKeyEvent(KeyEvent var1);
}

