/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;

public final class CompletionSettings
implements SettingsChangeListener {
    public static final CompletionSettings INSTANCE = new CompletionSettings();
    private static final Object NULL_VALUE = new Object();
    private Reference<JTextComponent> editorComponentRef;
    private Map<String, Object> settingName2value = new HashMap<String, Object>();

    private CompletionSettings() {
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public boolean completionAutoPopup() {
        return (Boolean)this.getValue("completion-auto-popup", ExtSettingsDefaults.defaultCompletionAutoPopup);
    }

    public int completionAutoPopupDelay() {
        return (Integer)this.getValue("completion-auto-popup-delay", ExtSettingsDefaults.defaultCompletionAutoPopupDelay);
    }

    public boolean documentationAutoPopup() {
        return (Boolean)this.getValue("javadoc-auto-popup", ExtSettingsDefaults.defaultJavaDocAutoPopup);
    }

    public int documentationAutoPopupDelay() {
        return (Integer)this.getValue("javadoc-auto-popup-delay", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
    }

    public Dimension completionPopupMaximumSize() {
        return (Dimension)this.getValue("completion-pane-max-size", ExtSettingsDefaults.defaultCompletionPaneMaxSize);
    }

    public Dimension documentationPopupPreferredSize() {
        return (Dimension)this.getValue("javadoc-preferred-size", ExtSettingsDefaults.defaultJavaDocPreferredSize);
    }

    public Color documentationBackgroundColor() {
        return (Color)INSTANCE.getValue("javadoc-bg-color", ExtSettingsDefaults.defaultJavaDocBGColor);
    }

    public boolean completionInstantSubstitution() {
        return (Boolean)this.getValue("completion-instant-substitution", ExtSettingsDefaults.defaultCompletionInstantSubstitution);
    }

    public void notifyEditorComponentChange(JTextComponent newEditorComponent) {
        this.editorComponentRef = new WeakReference<JTextComponent>(newEditorComponent);
        this.clearSettingValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String settingName) {
        Object value;
        CompletionSettings completionSettings = this;
        synchronized (completionSettings) {
            value = this.settingName2value.get(settingName);
        }
        if (value == null) {
            Class kitClass;
            JTextComponent c = this.editorComponentRef.get();
            if (c != null && (kitClass = Utilities.getKitClass((JTextComponent)c)) != null && (value = Settings.getValue((Class)kitClass, (String)settingName)) == null) {
                value = NULL_VALUE;
            }
            if (value != null) {
                CompletionSettings completionSettings2 = this;
                synchronized (completionSettings2) {
                    this.settingName2value.put(settingName, value);
                }
            }
        }
        if (value == NULL_VALUE) {
            value = null;
        }
        return value;
    }

    public Object getValue(String settingName, Object defaultValue) {
        Object value = this.getValue(settingName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.clearSettingValues();
    }

    private synchronized void clearSettingValues() {
        this.settingName2value.clear();
    }
}

