/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

public class FileDeletePlugin
implements RefactoringPlugin {
    private SafeDeleteRefactoring refactoring;

    public FileDeletePlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        for (FileObject fo : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            elements.addFileChange(this.refactoring, new DeleteFile(fo, elements));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class DeleteFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private RefactoringElementsBag session;
        BackupFacility.Handle id;

        public DeleteFile(FileObject fo, RefactoringElementsBag session) {
            this.fo = fo;
            this.session = session;
        }

        public String getText() {
            return "Delete file " + this.fo.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                if (!this.fo.isValid()) {
                    this.fo = FileUtil.toFileObject((File)new File(this.fo.getPath()));
                }
                this.id = BackupFacility.getDefault().backup(this.fo);
                DataObject.find((FileObject)this.fo).delete();
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                this.id.restore();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

