/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

public class FileRenamePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;

    public FileRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        elements.addFileChange(this.refactoring, new RenameFile((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class), elements));
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private class RenameFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private String oldName;

        public RenameFile(FileObject fo, RefactoringElementsBag bag) {
            this.fo = fo;
        }

        public String getText() {
            return "Rename file " + this.fo.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                this.oldName = this.fo.getName();
                DataObject.find((FileObject)this.fo).rename(FileRenamePlugin.this.refactoring.getNewName());
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                DataObject.find((FileObject)this.fo).rename(this.oldName);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

