/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanelContainer;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class PreviewManager {
    private static PreviewManager manager;
    private WeakHashMap<RefactoringPanel, HashMap<FileObject, Pair>> map = new WeakHashMap();

    private PreviewManager() {
    }

    public static PreviewManager getDefault() {
        if (manager == null) {
            manager = new PreviewManager();
        }
        return manager;
    }

    public void clean(RefactoringPanel panel) {
        this.map.remove(panel);
    }

    private Pair getPair(SimpleRefactoringElementImplementation element) {
        Pair pair;
        RefactoringPanel current = RefactoringPanelContainer.getRefactoringComponent().getCurrentPanel();
        HashMap<Object, Pair> m = this.map.get(current);
        if (m != null && (pair = m.get(element.getParentFile())) != null) {
            return pair;
        }
        try {
            NewDiffSource nds = new NewDiffSource(element);
            DiffController diffView = DiffController.create((StreamSource)new OldDiffSource(element), (StreamSource)nds);
            if (m == null) {
                m = new HashMap();
                this.map.put(current, m);
            }
            Pair p = new Pair(diffView, nds);
            m.put(element.getParentFile(), p);
            return p;
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
    }

    public void refresh(SimpleRefactoringElementImplementation element) {
        try {
            String newText = SPIAccessor.DEFAULT.getNewFileContent(element);
            if (newText == null) {
                UI.setComponentForRefactoringPreview(null);
                return;
            }
            Pair p = this.getPair(element);
            UI.setComponentForRefactoringPreview(p.dc.getJComponent());
            p.source.setNewText(newText);
            p.dc.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, element.getPosition().getBegin().getLine());
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
    }

    private class NewDiffSource
    extends StreamSource {
        private SimpleRefactoringElementImplementation element;
        private Document internal;

        NewDiffSource(SimpleRefactoringElementImplementation r) {
            this.element = r;
        }

        public String getName() {
            return "Proposed refactoring";
        }

        public String getTitle() {
            return "Refactored " + this.element.getParentFile().getNameExt();
        }

        public String getMIMEType() {
            return this.element.getParentFile().getMIMEType();
        }

        public Reader createReader() throws IOException {
            return null;
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }

        private Document getDocument() {
            if (this.internal == null) {
                this.internal = CloneableEditorSupport.getEditorKit((String)this.getMIMEType()).createDefaultDocument();
            }
            return this.internal;
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.getDocument());
        }

        public void setNewText(String r) {
            try {
                this.internal.remove(0, this.internal.getLength());
                this.internal.insertString(0, r, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private class OldDiffSource
    extends StreamSource {
        private FileObject file;

        OldDiffSource(SimpleRefactoringElementImplementation r) {
            this.file = r.getParentFile();
        }

        public String getName() {
            return this.file.getName();
        }

        public String getTitle() {
            return this.file.getNameExt();
        }

        public String getMIMEType() {
            return this.file.getMIMEType();
        }

        public Reader createReader() throws IOException {
            return null;
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.file);
        }
    }

    private class Pair {
        DiffController dc;
        NewDiffSource source;

        Pair(DiffController dc, NewDiffSource source) {
            this.dc = dc;
            this.source = source;
        }
    }
}

