/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class RedoAction
extends CallableSystemAction
implements PropertyChangeListener {
    private UndoManager undoManager;

    public RedoAction() {
        this.putValue("Name", RedoAction.getString("LBL_Redo"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.undoManager = UndoManager.getDefault();
        this.undoManager.addPropertyChangeListener(this);
        this.updateState();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateState();
    }

    private void updateState() {
        String desc = this.undoManager.getRedoDescription();
        String name = RedoAction.getString("LBL_Redo");
        if (desc != null) {
            name = name + " [" + desc + "]";
        }
        final String n = name;
        Runnable r = new Runnable(){

            public void run() {
                RedoAction.this.setEnabled(RedoAction.this.undoManager.isRedoAvailable());
                RedoAction.this.putValue("Name", n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(RedoAction.class, (String)key);
    }

    public void performAction() {
        this.undoManager.redo();
        this.undoManager.saveAll();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    protected boolean asynchronous() {
        return true;
    }
}

