/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.TextAction;
import org.netbeans.modules.refactoring.spi.impl.RefactoringGlobalAction;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class RefactoringSubMenuAction
extends TextAction
implements Presenter.Menu,
Presenter.Popup {
    private final boolean showIcons;

    public static RefactoringSubMenuAction create(FileObject o) {
        return new RefactoringSubMenuAction(true);
    }

    public static JMenu createMenu() {
        RefactoringSubMenuAction action = new RefactoringSubMenuAction(true);
        return (JMenu)action.getMenuPresenter();
    }

    RefactoringSubMenuAction(boolean showIcons) {
        super(NbBundle.getMessage(RefactoringSubMenuAction.class, (String)"LBL_Action"));
        this.showIcons = showIcons;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public JMenuItem getMenuPresenter() {
        return new SubMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public boolean equals(Object o) {
        return o instanceof RefactoringSubMenuAction;
    }

    public int hashCode() {
        return 1;
    }

    private class SubMenu
    extends JMenuPlus
    implements LookupListener {
        private ArrayList actions;
        private Lookup.Result nodes;
        private boolean nodesChanged;

        public SubMenu() {
            super((String)RefactoringSubMenuAction.this.getValue("Name"));
            this.actions = null;
            this.nodes = null;
            this.nodesChanged = true;
            if (RefactoringSubMenuAction.this.showIcons) {
                this.setMnemonic(NbBundle.getMessage(RefactoringSubMenuAction.class, (String)"LBL_ActionMnemonic").charAt(0));
            }
        }

        public JPopupMenu getPopupMenu() {
            if (this.actions == null) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.actions = new ArrayList();
            this.removeAll();
            FileSystem dfs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = dfs.findResource("Menu/Refactoring");
            DataFolder df = DataFolder.findFolder((FileObject)fo);
            if (df != null) {
                DataObject[] actionObjects = df.getChildren();
                for (int i = 0; i < actionObjects.length; ++i) {
                    JMenuItem mi;
                    Object instance;
                    InstanceCookie ic = (InstanceCookie)actionObjects[i].getCookie(InstanceCookie.class);
                    if (ic == null) continue;
                    try {
                        instance = ic.instanceCreate();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (instance instanceof RefactoringGlobalAction) {
                        this.actions.add(instance);
                        mi = new JMenuItem();
                        Actions.connect((JMenuItem)mi, (Action)((Action)instance), (boolean)true);
                        if (!RefactoringSubMenuAction.this.showIcons) {
                            mi.setIcon(null);
                        }
                        this.add(mi);
                        continue;
                    }
                    if (instance instanceof JSeparator) {
                        this.add((JSeparator)instance);
                        continue;
                    }
                    if (instance instanceof Presenter.Popup) {
                        JMenuItem temp = ((Presenter.Popup)instance).getPopupPresenter();
                        if (!RefactoringSubMenuAction.this.showIcons) {
                            temp.setIcon(null);
                        }
                        this.add(temp);
                        continue;
                    }
                    if (!(instance instanceof Action)) continue;
                    mi = new JMenuItem();
                    Actions.connect((JMenuItem)mi, (Action)((Action)instance), (boolean)true);
                    if (!RefactoringSubMenuAction.this.showIcons) {
                        mi.setIcon(null);
                    }
                    this.add(mi);
                }
            }
        }

        private void setText(JMenuItem t, Action a) {
            String name = (String)a.getValue("Name");
            int i = Mnemonics.findMnemonicAmpersand((String)name);
            if (i < 0) {
                t.setText(name);
            } else {
                t.setText(name.substring(0, i) + name.substring(i + 1));
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.nodesChanged = true;
        }
    }
}

