/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributesUtilities {
    private static final String ATTR_DISMANTLED_STRUCTURE = "dismantled-structure";

    public static AttributeSet createImmutable(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = keyValuePairs.length / 2 - 1; i >= 0; --i) {
            Object attrKey = keyValuePairs[2 * i];
            Object attrValue = keyValuePairs[2 * i + 1];
            map.put(attrKey, attrValue);
        }
        return new Immutable(map);
    }

    public static AttributeSet createImmutable(AttributeSet ... sets) {
        HashMap map = new HashMap();
        for (int i = sets.length - 1; i >= 0; --i) {
            AttributeSet set = sets[i];
            Enumeration<?> keys = set.getAttributeNames();
            while (keys.hasMoreElements()) {
                Object attrKey = keys.nextElement();
                Object attrValue = set.getAttribute(attrKey);
                map.put(attrKey, attrValue);
            }
        }
        return new Immutable(map);
    }

    public static AttributeSet createComposite(AttributeSet ... sets) {
        if (sets.length == 0) {
            return SimpleAttributeSet.EMPTY;
        }
        if (sets.length == 1) {
            return sets[0];
        }
        ArrayList<AttributeSet> all = new ArrayList<AttributeSet>();
        for (AttributeSet s : sets) {
            if (s instanceof Composite) {
                all.addAll(((Composite)s).getDelegates());
                continue;
            }
            if (s instanceof Proxy) {
                all.add(((Proxy)s).getDelegate());
                continue;
            }
            if (s == null || s == SimpleAttributeSet.EMPTY) continue;
            all.add(s);
        }
        if (all.size() == 0) {
            return SimpleAttributeSet.EMPTY;
        }
        if (all.size() == 1) {
            return (AttributeSet)all.get(0);
        }
        return new Composite(all.toArray(new AttributeSet[all.size()]));
    }

    private static List<AttributeSet> dismantle(AttributeSet set) {
        ArrayList<AttributeSet> sets = new ArrayList<AttributeSet>();
        if (set instanceof Proxy) {
            sets.addAll(AttributesUtilities.dismantle(((Proxy)set).getDelegate()));
        } else if (set instanceof Composite) {
            List<AttributeSet> delegates = ((Composite)set).getDelegates();
            for (AttributeSet delegate : delegates) {
                sets.addAll(AttributesUtilities.dismantle(delegate));
            }
        } else {
            sets.add(set);
        }
        return sets;
    }

    private AttributesUtilities() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Composite
    implements AttributeSet {
        private final AttributeSet[] delegates;

        public Composite(AttributeSet ... delegates) {
            this.delegates = delegates;
        }

        public List<AttributeSet> getDelegates() {
            return Arrays.asList(this.delegates);
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            return this.containsAttributes(attr) && attr.containsAttributes(this);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributes) {
            Enumeration<?> keys = attributes.getAttributeNames();
            while (keys.hasMoreElements()) {
                Object value;
                Object key = keys.nextElement();
                if (this.containsAttribute(key, value = attributes.getAttribute(key))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isDefined(Object key) {
            for (AttributeSet delegate : this.delegates) {
                if (!delegate.isDefined(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getAttribute(Object key) {
            if (key instanceof String && key.equals(AttributesUtilities.ATTR_DISMANTLED_STRUCTURE)) {
                return AttributesUtilities.dismantle(this);
            }
            for (AttributeSet delegate : this.delegates) {
                if (!delegate.isDefined(key)) continue;
                return delegate.getAttribute(key);
            }
            return null;
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return Collections.enumeration(this.getAllKeys());
        }

        @Override
        public int getAttributeCount() {
            return this.getAllKeys().size();
        }

        @Override
        public AttributeSet copyAttributes() {
            return AttributesUtilities.createImmutable(this.delegates);
        }

        @Override
        public boolean containsAttribute(Object key, Object value) {
            for (AttributeSet delegate : this.delegates) {
                if (!delegate.containsAttribute(key, value)) continue;
                return true;
            }
            return false;
        }

        private Collection<?> getAllKeys() {
            HashSet allKeys = new HashSet();
            for (AttributeSet delegate : this.delegates) {
                Enumeration<?> keys = delegate.getAttributeNames();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    allKeys.add(key);
                }
            }
            return allKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Immutable
    implements AttributeSet {
        private final HashMap<Object, Object> attribs;
        private AttributeSet parent = null;

        private Immutable(HashMap<Object, Object> attribs) {
            this.attribs = attribs == null ? new HashMap() : attribs;
        }

        public synchronized void setResolveParent(AttributeSet parent) {
            this.parent = parent;
        }

        @Override
        public synchronized boolean containsAttributes(AttributeSet attributes) {
            Enumeration<?> names = attributes.getAttributeNames();
            while (names.hasMoreElements()) {
                Object value;
                Object name = names.nextElement();
                if (this.containsAttribute(name, value = attributes.getAttribute(name))) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized boolean isEqual(AttributeSet attr) {
            return this.containsAttributes(attr) && attr.containsAttributes(this);
        }

        @Override
        public synchronized Object getAttribute(Object key) {
            if (AttributeSet.ResolveAttribute == key) {
                return this.parent;
            }
            if (this.attribs.containsKey(key)) {
                return this.attribs.get(key);
            }
            if (this.parent != null) {
                return this.parent.getAttribute(key);
            }
            return null;
        }

        @Override
        public synchronized boolean isDefined(Object key) {
            return this.attribs.containsKey(key);
        }

        @Override
        public synchronized boolean containsAttribute(Object key, Object value) {
            if (this.attribs.containsKey(key)) {
                Object attrValue = this.attribs.get(key);
                if (value == null && attrValue == null || value != null && attrValue != null && value.equals(attrValue)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public AttributeSet copyAttributes() {
            return new Proxy(this);
        }

        @Override
        public synchronized int getAttributeCount() {
            return this.attribs.size();
        }

        @Override
        public synchronized Enumeration<?> getAttributeNames() {
            return Collections.enumeration(this.attribs.keySet());
        }

        @Override
        public synchronized AttributeSet getResolveParent() {
            return this.parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Proxy
    implements AttributeSet {
        private AttributeSet original;

        public Proxy(AttributeSet original) {
            this.original = original;
        }

        public AttributeSet getDelegate() {
            return this.original;
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            return this.original.isEqual(attr);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributes) {
            return this.original.containsAttributes(attributes);
        }

        @Override
        public boolean isDefined(Object attrName) {
            return this.original.isDefined(attrName);
        }

        @Override
        public Object getAttribute(Object key) {
            if (key instanceof String && key.equals(AttributesUtilities.ATTR_DISMANTLED_STRUCTURE)) {
                return AttributesUtilities.dismantle(this);
            }
            return this.original.getAttribute(key);
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.original.getResolveParent();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.original.getAttributeNames();
        }

        @Override
        public int getAttributeCount() {
            return this.original.getAttributeCount();
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.original.copyAttributes();
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return this.original.containsAttribute(name, value);
        }
    }
}

