/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerRegistry {
    static final String INSTALLER_REGISTRY_FOLDER = "org-netbeans-api-java/platform/installers";
    static Reference<InstallerRegistry> defaultInstance = new WeakReference<Object>(null);
    private Provider provider;
    private List<GeneralPlatformInstall> platformInstalls;

    InstallerRegistry(FileObject registryResource) {
        assert (registryResource != null);
        this.provider = new Provider(registryResource);
    }

    InstallerRegistry(GeneralPlatformInstall[] platformInstalls) {
        assert (platformInstalls != null);
        this.platformInstalls = Arrays.asList(platformInstalls);
    }

    public List<PlatformInstall> getInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), PlatformInstall.class);
    }

    public List<CustomPlatformInstall> getCustomInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), CustomPlatformInstall.class);
    }

    public List<GeneralPlatformInstall> getAllInstallers() {
        if (this.platformInstalls != null) {
            return this.platformInstalls;
        }
        List list = Collections.emptyList();
        try {
            assert (this.provider != null);
            list = NbCollections.checkedListByCopy((List)((List)this.provider.instanceCreate()), GeneralPlatformInstall.class, (boolean)true);
        }
        catch (IOException ex) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    public static InstallerRegistry getDefault() {
        InstallerRegistry regs = defaultInstance.get();
        if (regs != null) {
            return regs;
        }
        regs = new InstallerRegistry(Repository.getDefault().getDefaultFileSystem().findResource(INSTALLER_REGISTRY_FOLDER));
        defaultInstance = new WeakReference<InstallerRegistry>(regs);
        return regs;
    }

    static InstallerRegistry prepareForUnitTest(GeneralPlatformInstall[] platformInstalls) {
        InstallerRegistry regs = new InstallerRegistry(platformInstalls);
        defaultInstance = new WeakReference<InstallerRegistry>(regs);
        return regs;
    }

    private static <T> List<T> filter(List<?> list, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (Object item : list) {
            if (!clazz.isInstance(item)) continue;
            result.add(clazz.cast(item));
        }
        return result;
    }

    private static class Provider
    extends FolderInstance {
        Provider(FileObject registryResource) {
            super(DataFolder.findFolder((FileObject)registryResource));
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            ArrayList<Object> installers = new ArrayList<Object>(cookies.length);
            for (int i = 0; i < cookies.length; ++i) {
                InstanceCookie cake = cookies[i];
                Object o = null;
                try {
                    if (cake instanceof InstanceCookie.Of && !((InstanceCookie.Of)cake).instanceOf(PlatformInstall.class) && !((InstanceCookie.Of)cake).instanceOf(CustomPlatformInstall.class)) continue;
                    o = cake.instanceCreate();
                }
                catch (IOException ex) {
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (o == null) continue;
                installers.add(o);
            }
            return installers;
        }
    }
}

