/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class PlatformSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private static final String JAR_FILE = "jar:file:";
    private static final String RTJAR_PATH = "/jre/lib/rt.jar!/";
    private static final String SRC_ZIP = "/src.zip";
    private Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        for (JavaPlatform platform : mgr.getInstalledPlatforms()) {
            for (ClassPath.Entry entry : platform.getBootstrapLibraries().entries()) {
                if (!entry.getURL().equals(binaryRoot)) continue;
                res = new Result(platform);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        String binaryRootS = binaryRoot.toExternalForm();
        if (binaryRootS.startsWith(JAR_FILE) && binaryRootS.endsWith(RTJAR_PATH)) {
            String srcZipS = binaryRootS.substring(4, binaryRootS.length() - RTJAR_PATH.length()) + SRC_ZIP;
            try {
                URL srcZip = FileUtil.getArchiveRoot((URL)new URL(srcZipS));
                FileObject fo = URLMapper.findFileObject((URL)srcZip);
                if (fo != null) {
                    return new UnregisteredPlatformResult(fo);
                }
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
        }
        return null;
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private JavaPlatform platform;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public Result(JavaPlatform platform) {
            this.platform = platform;
            this.platform.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)platform));
        }

        public FileObject[] getRoots() {
            ClassPath sources = this.platform.getSourceFolders();
            return sources.getRoots();
        }

        public void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.removeChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("sourceFolders".equals(event.getPropertyName())) {
                this.cs.fireChange();
            }
        }
    }

    private static class UnregisteredPlatformResult
    implements SourceForBinaryQuery.Result {
        private FileObject srcRoot;

        private UnregisteredPlatformResult(FileObject fo) {
            assert (fo != null);
            this.srcRoot = fo;
        }

        public FileObject[] getRoots() {
            FileObject[] fileObjectArray;
            if (this.srcRoot.isValid()) {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = this.srcRoot;
            } else {
                fileObjectArray = new FileObject[]{};
            }
            return fileObjectArray;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

