/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.platform.InstallerRegistry;
import org.netbeans.modules.java.platform.wizard.LocationChooser;
import org.netbeans.modules.java.platform.wizard.SelectorPanel;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PlatformInstallIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    WizardDescriptor.InstantiatingIterator typeIterator;
    int panelIndex;
    boolean hasSelectorPanel;
    WizardDescriptor wizard;
    int panelNumber = -1;
    ResourceBundle bundle = NbBundle.getBundle(PlatformInstallIterator.class);
    LocationChooser.Panel locationPanel = new LocationChooser.Panel();
    SelectorPanel.Panel selectorPanel = new SelectorPanel.Panel();
    Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();

    PlatformInstallIterator() {
        this.selectorPanel.addChangeListener(this);
        this.locationPanel.addChangeListener(this);
    }

    public static PlatformInstallIterator create() {
        return new PlatformInstallIterator();
    }

    int getPanelIndex() {
        return this.panelIndex;
    }

    void updatePanelsList(JComponent[] where) {
        LinkedList<String> c = new LinkedList<String>();
        if (this.hasSelectorPanel) {
            c.add(this.bundle.getString("TXT_SelectPlatformTypeTitle"));
        }
        if (this.panelIndex == 1 || this.panelIndex == 2 || this.panelIndex == 0 && this.selectorPanel.getInstallerIterator() == null) {
            c.add(this.bundle.getString("TXT_PlatformFolderTitle"));
        }
        if (this.typeIterator != null) {
            JComponent pc;
            String[] steps;
            WizardDescriptor.Panel p = this.typeIterator.current();
            if (p != null && (steps = (String[])(pc = (JComponent)p.getComponent()).getClientProperty("WizardPanel_contentData")) != null) {
                c.addAll(Arrays.asList(steps));
            }
        } else {
            c.add(this.bundle.getString("TITLE_PlatformLocationUnknown"));
        }
        String[] names = c.toArray(new String[c.size()]);
        for (JComponent comp : where) {
            comp.putClientProperty("WizardPanel_contentData", names);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public WizardDescriptor.Panel current() {
        if (this.panelIndex == 0) {
            return this.selectorPanel;
        }
        if (this.panelIndex == 1) {
            return this.locationPanel;
        }
        return this.typeIterator.current();
    }

    public boolean hasNext() {
        if (this.panelIndex == 0) {
            WizardDescriptor.InstantiatingIterator typeIt = this.selectorPanel.getInstallerIterator();
            if (typeIt == null) {
                return true;
            }
            return typeIt.current() != null;
        }
        if (this.panelIndex == 1) {
            WizardDescriptor.InstantiatingIterator typeIt = this.locationPanel.getInstallerIterator();
            if (typeIt == null) {
                return false;
            }
            WizardDescriptor.Panel p = typeIt.current();
            return p != null;
        }
        return this.typeIterator.hasNext();
    }

    public boolean hasPrevious() {
        return !(this.panelIndex == 0 || this.panelIndex == 1 && !this.hasSelectorPanel || this.panelIndex == 3 && !this.hasSelectorPanel && this.typeIterator != null && !this.typeIterator.hasPrevious());
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizard = wiz;
        List<GeneralPlatformInstall> installers = InstallerRegistry.getDefault().getAllInstallers();
        if (installers.size() > 1) {
            this.panelIndex = 0;
            this.hasSelectorPanel = true;
        } else if (installers.get(0) instanceof CustomPlatformInstall) {
            this.panelIndex = 3;
            this.hasSelectorPanel = false;
            this.typeIterator = ((CustomPlatformInstall)installers.get(0)).createIterator();
        } else {
            this.panelIndex = 1;
            this.hasSelectorPanel = false;
            this.locationPanel.setPlatformInstall((PlatformInstall)installers.get(0));
        }
        this.updatePanelsList(new JComponent[]{(JComponent)this.current().getComponent()});
        this.wizard.setTitle(NbBundle.getMessage(PlatformInstallIterator.class, (String)"TXT_AddPlatformTitle"));
        this.panelNumber = 0;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public Set instantiate() throws IOException {
        return this.typeIterator.instantiate();
    }

    public String name() {
        if (this.panelIndex == 0) {
            return this.bundle.getString("TXT_PlatformSelectorTitle");
        }
        if (this.panelIndex == 1) {
            return this.bundle.getString("TXT_PlatformFolderTitle");
        }
        return this.typeIterator.name();
    }

    public void nextPanel() {
        if (this.panelIndex == 0) {
            this.panelIndex = this.selectorPanel.getInstallerIterator() == null ? 1 : 3;
        } else if (this.panelIndex == 1) {
            this.panelIndex = 2;
        } else {
            this.typeIterator.nextPanel();
        }
        ++this.panelNumber;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public void previousPanel() {
        if (this.panelIndex == 1) {
            this.panelIndex = 0;
        } else if (this.panelIndex == 2) {
            if (this.typeIterator.hasPrevious()) {
                this.typeIterator.previousPanel();
            } else {
                this.panelIndex = 1;
            }
        } else if (this.panelIndex == 3) {
            if (this.typeIterator.hasPrevious()) {
                this.typeIterator.previousPanel();
            } else {
                this.panelIndex = 0;
            }
        }
        --this.panelNumber;
        this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.typeIterator != null) {
            this.typeIterator.uninitialize(wiz);
        }
    }

    public void stateChanged(ChangeEvent e) {
        WizardDescriptor.InstantiatingIterator it;
        if (e.getSource() == this.locationPanel) {
            it = this.locationPanel.getInstallerIterator();
        } else if (e.getSource() == this.selectorPanel) {
            GeneralPlatformInstall installer = this.selectorPanel.getInstaller();
            if (installer instanceof CustomPlatformInstall) {
                it = ((CustomPlatformInstall)installer).createIterator();
            } else {
                it = null;
                this.locationPanel.setPlatformInstall((PlatformInstall)installer);
            }
        } else {
            assert (false) : "Unknown event source";
            return;
        }
        if (it != this.typeIterator) {
            if (this.typeIterator != null) {
                this.typeIterator.uninitialize(this.wizard);
            }
            this.typeIterator = it;
            if (this.typeIterator != null) {
                this.typeIterator.initialize(this.wizard);
                this.updatePanelsList(new JComponent[]{(JComponent)this.selectorPanel.getComponent(), (JComponent)this.locationPanel.getComponent(), (JComponent)this.typeIterator.current().getComponent()});
            } else {
                this.updatePanelsList(new JComponent[]{(JComponent)this.selectorPanel.getComponent(), (JComponent)this.locationPanel.getComponent()});
            }
            this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(this.panelNumber));
        }
    }
}

