/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.scanner;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.insane.impl.InsaneEngine;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.Visitor;

public final class ScannerUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ScannerUtils() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public static Visitor compoundVisitor(final Visitor[] visitorArray) {
        return new Visitor(){
            private final Visitor[] sub;
            {
                this.sub = (Visitor[])visitorArray.clone();
            }

            public void visitClass(Class clazz) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitClass(clazz);
                }
            }

            public void visitObject(ObjectMap objectMap, Object object) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitObject(objectMap, object);
                }
            }

            public void visitObjectReference(ObjectMap objectMap, Object object, Object object2, Field field) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitObjectReference(objectMap, object, object2, field);
                }
            }

            public void visitArrayReference(ObjectMap objectMap, Object object, Object object2, int n) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitArrayReference(objectMap, object, object2, n);
                }
            }

            public void visitStaticReference(ObjectMap objectMap, Object object, Field field) {
                for (int i = 0; i < this.sub.length; ++i) {
                    this.sub[i].visitStaticReference(objectMap, object, field);
                }
            }
        };
    }

    public static Filter compoundFilter(final Filter[] filterArray) {
        return new Filter(){
            private final Filter[] sub;
            {
                this.sub = (Filter[])filterArray.clone();
            }

            public boolean accept(Object object, Object object2, Field field) {
                for (int i = 0; i < this.sub.length; ++i) {
                    if (this.sub[i].accept(object, object2, field)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Filter skipObjectsFilter(Collection collection, boolean bl) {
        class Except
        implements Filter {
            private final IdentityHashMap skip = new IdentityHashMap();
            private final /* synthetic */ boolean val$include;

            Except(Collection collection, boolean bl) {
                this.val$include = bl;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.skip.put(iterator.next(), Boolean.TRUE);
                }
            }

            public boolean accept(Object object, Object object2, Field field) {
                return !this.skip.containsKey(this.val$include ? object2 : object);
            }
        }
        return new Except(collection, bl);
    }

    public static Filter skipReferencesFilter(final Collection collection) {
        return new Filter(){
            private final Set skip;
            {
                this.skip = new HashSet(collection);
            }

            public boolean accept(Object object, Object object2, Field field) {
                return !this.skip.contains(field);
            }
        };
    }

    public static Filter skipNonStrongReferencesFilter() {
        Class clazz = Reference.class;
        try {
            Field field = clazz.getDeclaredField("referent");
            return ScannerUtils.skipReferencesFilter(Collections.singleton(field));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(noSuchFieldException.toString());
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    public static Filter noFilter() {
        return new Filter(){

            public boolean accept(Object object, Object object2, Field field) {
                return true;
            }
        };
    }

    public static int sizeOf(Object object) {
        return ClassInfo.sizeOf(object);
    }

    public static int recursiveSizeOf(Collection collection, Filter filter) throws Exception {
        CountingVisitor countingVisitor = new CountingVisitor();
        ScannerUtils.scan(filter, countingVisitor, collection, false);
        return countingVisitor.getTotalSize();
    }

    public static void scan(Filter filter, Visitor visitor, Collection collection, boolean bl) throws Exception {
        new InsaneEngine(filter, visitor, bl).traverse(collection);
    }

    public static Set interestingRoots() {
        return new HashSet<Object>(Arrays.asList(Thread.currentThread(), ScannerUtils.class.getClassLoader()));
    }

    public static void scanExclusivelyInAWT(final Filter filter, final Visitor visitor, final Set set) throws Exception {
        Thread thread = Thread.currentThread();
        final Exception[] exceptionArray = new Exception[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ScannerUtils.scan(filter, visitor, set, true);
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
        if (exceptionArray[0] != null) {
            throw exceptionArray[0];
        }
    }

    private static Thread[] getAllThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadArray = new Thread[2 * threadGroup.activeCount() + 5];
        int n = threadGroup.enumerate(threadArray);
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, n);
        return threadArray2;
    }

    private static void suspendAllThreads(Set set) {
        Thread[] threadArray = ScannerUtils.getAllThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            if (set.contains(threadArray[i]) || threadArray[i].getName().indexOf("VM") != -1 || threadArray[i].getName().indexOf("CompilerTh") != -1 || threadArray[i].getName().indexOf("Signal") != -1) continue;
            System.out.println("suspending " + threadArray[i]);
            threadArray[i].suspend();
        }
    }

    private static void resumeAllThreads() {
        Thread[] threadArray = ScannerUtils.getAllThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            threadArray[i].resume();
        }
    }

    static {
        $assertionsDisabled = !ScannerUtils.class.desiredAssertionStatus();
    }

    private static class ClassInfo {
        private static Map classInfoRegistry = new WeakHashMap();
        private int size;

        private ClassInfo(Class clazz) {
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                this.size = -ClassInfo.getSize(clazz2, true);
            } else {
                int n = 0;
                for (Class clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                    Field[] fieldArray = clazz3.getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        if ((fieldArray[i].getModifiers() & 8) != 0) continue;
                        n += ClassInfo.getSize(fieldArray[i].getType(), false);
                    }
                }
                this.size = n + 8 + 7 & 0xFFFFFFF8;
            }
        }

        static int sizeOf(Object object) {
            Class<?> clazz = object.getClass();
            ClassInfo classInfo = (ClassInfo)classInfoRegistry.get(clazz);
            if (classInfo == null) {
                classInfo = new ClassInfo(clazz);
                classInfoRegistry.put(clazz, classInfo);
            }
            return classInfo.size > 0 ? classInfo.size : 19 - classInfo.size * Array.getLength(object) & 0xFFFFFFF8;
        }

        private static int getSize(Class clazz, boolean bl) {
            if (bl) {
                if (clazz == Byte.TYPE || clazz == Boolean.TYPE) {
                    return 1;
                }
                if (clazz == Short.TYPE || clazz == Character.TYPE) {
                    return 2;
                }
                if (clazz == Integer.TYPE || clazz == Float.TYPE) {
                    return 4;
                }
                if (clazz == Long.TYPE || clazz == Double.TYPE) {
                    return 8;
                }
                return 4;
            }
            if (clazz == Long.TYPE || clazz == Double.TYPE) {
                return 8;
            }
            return 4;
        }
    }
}

