/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.AvailableTableModel;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.InstalledTableModel;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.netbeans.modules.autoupdate.ui.SplittedUnitTab;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PluginManagerUI
extends JPanel
implements UpdateUnitListener {
    private List<UpdateUnit> units = Collections.emptyList();
    private UnitTable installedTable;
    private UnitTable availableTable;
    private UnitTable updateTable;
    private UnitTable localTable;
    private JButton closeButton;
    private SettingsTab settingTab;
    private JButton bClose;
    private JPanel pProgress;
    private JTabbedPane tpTabs;

    public PluginManagerUI(JButton closeButton) {
        this.closeButton = closeButton;
        this.initComponents();
        this.postInitComponents();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                PluginManagerUI.this.units = UpdateManager.getDefault().getUpdateUnits();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PluginManagerUI.this.refreshUnits();
                    }
                });
            }
        });
    }

    void setProgressComponent(final JLabel detail, final JComponent progressComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponentInAwt(detail, progressComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginManagerUI.this.setProgressComponentInAwt(detail, progressComponent);
                }
            });
        }
    }

    private void setProgressComponentInAwt(JLabel detail, JComponent progressComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        this.pProgress.setVisible(true);
        this.pProgress.add((Component)detail, "Center");
        this.pProgress.add((Component)progressComponent, "East");
        this.revalidate();
    }

    void unsetProgressComponent(final JLabel detail, final JComponent progressComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.unsetProgressComponentInAwt(detail, progressComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginManagerUI.this.unsetProgressComponentInAwt(detail, progressComponent);
                }
            });
        }
    }

    private void unsetProgressComponentInAwt(JLabel detail, JComponent progressComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        this.pProgress.remove(detail);
        this.pProgress.remove(progressComponent);
        this.pProgress.setVisible(false);
        this.revalidate();
    }

    private void initComponents() {
        this.tpTabs = new JTabbedPane();
        this.pProgress = new JPanel();
        this.bClose = this.closeButton;
        this.tpTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PluginManagerUI.this.tpTabsStateChanged(evt);
            }
        });
        this.pProgress.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bClose, (String)NbBundle.getMessage(PluginManagerUI.class, (String)"UnitTab_bClose_Text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pProgress, -2, 562, -2).addPreferredGap(0, 121, Short.MAX_VALUE).add((Component)this.bClose)).add((Component)this.tpTabs, -1, 730, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.tpTabs, -1, 471, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.bClose).add((Component)this.pProgress, -2, 17, -2)).addContainerGap()));
    }

    private void tpTabsStateChanged(ChangeEvent evt) {
        if (((JTabbedPane)evt.getSource()).getSelectedComponent().equals(this.settingTab)) {
            this.settingTab.getSettingsTableModel().refreshModel();
        }
    }

    private void postInitComponents() {
        Containers.initNotify();
        this.installedTable = new UnitTable(new InstalledTableModel(Utilities.makeInstalledCategories(this.units)));
        this.updateTable = new UnitTable(new UpdateTableModel(Utilities.makeUpdateCategories(this.units, false)));
        this.availableTable = new UnitTable(new AvailableTableModel(Utilities.makeAvailableCategories(this.units, false)));
        this.localTable = new UnitTable(new LocallyDownloadedTableModel(new ArrayList<UnitCategory>()));
        this.selectFirstRow(this.installedTable);
        this.selectFirstRow(this.updateTable);
        this.selectFirstRow(this.availableTable);
        SplittedUnitTab updateTab = new SplittedUnitTab(this.updateTable, new UnitDetails(), this);
        updateTab.addUpdateUnitListener(this);
        this.tpTabs.add(NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_Title"), updateTab);
        SplittedUnitTab availableTab = new SplittedUnitTab(this.availableTable, new UnitDetails(), this);
        availableTab.addUpdateUnitListener(this);
        this.tpTabs.add(NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_Title"), availableTab);
        SplittedUnitTab localTab = new SplittedUnitTab(this.localTable, new UnitDetails(), this);
        localTab.addUpdateUnitListener(this);
        this.tpTabs.add(NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Local_Title"), localTab);
        SplittedUnitTab installedTab = new SplittedUnitTab(this.installedTable, new UnitDetails(), this);
        installedTab.addUpdateUnitListener(this);
        this.tpTabs.add(NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Installed_Title"), installedTab);
        this.settingTab = new SettingsTab(this);
        this.tpTabs.add(this.settingTab.getDisplayName(), this.settingTab);
        this.decorateTitle(0, this.updateTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_Title"));
        this.decorateTitle(1, this.availableTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_Title"));
        this.decorateTitle(2, this.localTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Local_Title"));
        this.decorateTitle(3, this.installedTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Installed_Title"));
    }

    private void decorateTitle(int index, JTable table, String originalName) {
        int rawCount;
        TableModel model = table.getModel();
        assert (model instanceof UnitCategoryTableModel) : model + " is instanceof UnitCategoryTableModel.";
        UnitCategoryTableModel catModel = (UnitCategoryTableModel)model;
        int count = catModel.getItemCount();
        String countInfo = count == (rawCount = catModel.getRawItemCount()) ? String.valueOf(rawCount) : NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_CountFormat", (Object)count, (Object)rawCount);
        String newName = NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_Tabs_NameFormat", (Object)originalName, (Object)countInfo);
        this.tpTabs.setTitleAt(index, count == 0 ? originalName : newName);
    }

    private int findRowWithFirstUnit(UnitCategoryTableModel model) {
        for (int row = 0; row <= model.getRowCount(); ++row) {
            if (model.getUnitAtRow(row) == null) continue;
            return row;
        }
        return -1;
    }

    private void selectFirstRow(UnitTable table) {
        UnitCategoryTableModel model;
        int row;
        if (table.getSelectedRow() == -1 && (row = this.findRowWithFirstUnit(model = (UnitCategoryTableModel)table.getModel())) != -1) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void refreshUnits() {
        this.units = UpdateManager.getDefault().getUpdateUnits();
        UnitCategoryTableModel installTableModel = (UnitCategoryTableModel)this.installedTable.getModel();
        UnitCategoryTableModel updateTableModel = (UnitCategoryTableModel)this.updateTable.getModel();
        UnitCategoryTableModel availableTableModel = (UnitCategoryTableModel)this.availableTable.getModel();
        UnitCategoryTableModel localTableModel = (UnitCategoryTableModel)this.localTable.getModel();
        updateTableModel.setData(Utilities.makeUpdateCategories(this.units, false));
        installTableModel.setData(Utilities.makeInstalledCategories(this.units));
        availableTableModel.setData(Utilities.makeAvailableCategories(this.units, false));
        this.selectFirstRow(this.installedTable);
        this.selectFirstRow(this.updateTable);
        this.selectFirstRow(this.availableTable);
        this.decorateTitle(0, this.updateTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_Title"));
        this.decorateTitle(1, this.availableTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_Title"));
        this.decorateTitle(2, this.localTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Local_Title"));
        this.decorateTitle(3, this.installedTable, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Installed_Title"));
    }

    static boolean canContinue(String message) {
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message)));
    }

    public void updateUnitsChanged() {
        this.refreshUnits();
    }

    public void buttonsChanged() {
        Component c = this.tpTabs.getSelectedComponent();
        if (c instanceof SplittedUnitTab) {
            ((SplittedUnitTab)c).refreshState();
        }
    }
}

