/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.CharConversionException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.ModuleProvider;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.modules.ModuleInfo;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");

    public void setUnitCategory(UnitCategory unitCategory) {
        String text = "<b>Category: </b>" + unitCategory.getCategoryName() + "<br>";
        this.getDetails().setText(text);
        this.getDetails().setCaretPosition(0);
    }

    public void setUnit(Unit u) {
        if (u == null) {
            this.getDetails().setText("No description.");
        } else {
            String text;
            try {
                text = "<h2>" + XMLUtil.toElementContent((String)u.getDisplayName()) + "</h2>";
                text = text + "<b>UpdateVersion: </b>" + u.getDisplayVersion() + "<br>";
                text = text + "<b>Author: </b>" + (u.getAuthor() == null ? "" : u.getAuthor()) + "<br>";
                text = text + "<b>Source: </b>" + u.getSource() + "<br>";
                if (u.updateUnit != null && u.updateUnit.getInstalled() != null) {
                    List<UpdateElement> elems;
                    UpdateElement elem = u.updateUnit.getInstalled();
                    ModuleInfo m = ModuleProvider.getInstalledModules().get(elem.getCodeName());
                    boolean isEnabled = m != null && m.isEnabled();
                    OperationContainer c = null;
                    c = isEnabled ? OperationContainer.createForDisable() : OperationContainer.createForEnable();
                    text = text + "<br><b>CodeName: </b>" + u.updateUnit.getCodeName() + "<br>";
                    text = text + (u.updateUnit.isAutoload() ? "<b>Autoload </b>" : "");
                    text = text + (u.updateUnit.isEager() ? "<b>Eager </b>" : "");
                    text = text + (u.updateUnit.isFixed() ? "<b>Fixed</b>" : "");
                    if (c.canBeAdded(u.updateUnit, elem) && (elems = Utilities.getRequiredElements(u.updateUnit, elem, (OperationContainer<OperationSupport>)c)).size() > 0) {
                        String pom = "";
                        for (UpdateElement updateElement : elems) {
                            pom = pom + updateElement.getDisplayName() + ", ";
                        }
                        text = isEnabled ? text + "<b>Required by: </b>" + pom + "<br>" : text + "<b>Requires: </b>" + pom + "<br>";
                    }
                }
                if (u.getHomepage() != null && u.getHomepage().length() > 0) {
                    text = text + "<b>Homepage: </b><a href=\"" + u.getHomepage() + "\">" + u.getHomepage() + "</a><br>";
                }
                text = text + "<h3>Plugin Description</h3>";
                text = text + (u.getDescription() == null ? "" : XMLUtil.toElementContent((String)u.getDescription()));
            }
            catch (CharConversionException e) {
                this.err.log(Level.WARNING, null, e);
                return;
            }
            this.getDetails().setText(text);
            this.getDetails().setCaretPosition(0);
        }
    }
}

