/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.autoupdate.ui.InstalledPluginColumn;
import org.netbeans.modules.autoupdate.ui.InstalledTableModel;
import org.netbeans.modules.autoupdate.ui.LocalPluginColumn;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginColumn;
import org.netbeans.modules.autoupdate.ui.SortColumnHeaderRenderer;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTableUI;
import org.openide.util.NbBundle;

public class UnitTable
extends JTable {
    private UnitCategoryTableModel model = null;
    private PluginColumn pluginColumn;
    private InstalledPluginColumn installedPluginColumn;
    private LocalPluginColumn localPluginColumn;
    private int defaultHeight;
    private static final Icon openedIcon = UIManager.getIcon("Tree.expandedIcon");
    private static final Icon closedIcon = UIManager.getIcon("Tree.collapsedIcon");

    public UnitTable(TableModel model) {
        super(model);
        this.defaultHeight = new JCheckBox((String)"", (boolean)true).getPreferredSize().height;
        this.model = (UnitCategoryTableModel)model;
        this.setDefaultRenderer(Boolean.class, new BooleanRenderer(this.getDefaultRenderer(Boolean.class)));
        if (UnitCategoryTableModel.Type.AVAILABLE == this.model.getType()) {
            this.pluginColumn = new PluginColumn(this, 1, this.model);
        }
        if (UnitCategoryTableModel.Type.UPDATE == this.model.getType()) {
            this.pluginColumn = new PluginColumn(this, 1, this.model);
        }
        if (UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            this.localPluginColumn = new LocalPluginColumn(this, 1, this.model);
        }
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType()) {
            this.installedPluginColumn = new InstalledPluginColumn(this, 1, this.model);
        }
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.getColumnModel().getColumn(3).setPreferredWidth(75);
        this.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.initTable();
        this.initActions();
        this.revalidate();
    }

    private void initActions() {
        String collapseKey = "CollapseAll";
        String expandKey = "ExpandAll";
        if (this.getActionMap().get("CollapseAll") == null) {
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(109, 192), "CollapseAll");
            inputMap.put(KeyStroke.getKeyStroke(107, 192), "ExpandAll");
            this.getActionMap().put("CollapseAll", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    UnitTable.this.model.collapseAll();
                    UnitTable.this.model.fireTableDataChanged();
                }
            });
            this.getActionMap().put("ExpandAll", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    UnitTable.this.model.expandAll();
                    UnitTable.this.model.fireTableDataChanged();
                }
            });
        }
    }

    private void initTable() {
        this.setSurrendersFocusOnKeystroke(true);
        this.setUI(new UnitTableUI(this.model));
        this.setRowHeight(this.defaultHeight);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = UnitTable.this.rowAtPoint(e.getPoint());
                if (UnitTable.this.model.isCategoryAtRow(row)) {
                    int col;
                    if (e.getClickCount() == 2) {
                        UnitTable.this.model.toggleCategoryExpanded(row);
                    } else if (e.getClickCount() == 1 && (col = UnitTable.this.columnAtPoint(e.getPoint())) == 0) {
                        UnitTable.this.model.toggleCategoryExpanded(row);
                    }
                }
            }
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent arg0) {
            }

            public void columnRemoved(TableColumnModelEvent arg0) {
            }

            public void columnMoved(TableColumnModelEvent arg0) {
            }

            public void columnMarginChanged(ChangeEvent arg0) {
            }

            public void columnSelectionChanged(ListSelectionEvent arg0) {
                UnitTable.this.modifyBooleanEditor(UnitTable.this.getSelectedRow());
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Component c;
                int row = UnitTable.this.getSelectedRow();
                UnitTable.this.setRowHeight(evt.getFirstIndex(), UnitTable.this.defaultHeight);
                UnitTable.this.setRowHeight(evt.getLastIndex(), UnitTable.this.defaultHeight);
                if (UnitTable.this.getSelectedColumn() == 0) {
                    UnitTable.this.modifyBooleanEditor(row);
                }
                if (!(UnitTable.this.model instanceof InstalledTableModel || UnitTable.this.model instanceof LocallyDownloadedTableModel || row == -1 || UnitTable.this.model.isCategoryAtRow(row))) {
                    c = null;
                    c = !UnitTable.this.isEditing() || UnitTable.this.getEditingColumn() != 1 ? UnitTable.this.pluginColumn.getTableCellRendererComponent(UnitTable.this, 0, true, true, row, 1) : UnitTable.this.pluginColumn.getTableCellEditorComponent(UnitTable.this, 0, true, row, 1);
                    UnitTable.this.setRowHeight(row, UnitTable.this.defaultHeight < c.getPreferredSize().height ? c.getPreferredSize().height : UnitTable.this.defaultHeight);
                }
                if (UnitTable.this.model instanceof InstalledTableModel && row != -1 && !UnitTable.this.model.isCategoryAtRow(row)) {
                    c = UnitTable.this.installedPluginColumn.getTableCellRendererComponent(UnitTable.this, 0, true, true, row, 1);
                    UnitTable.this.setRowHeight(row, UnitTable.this.defaultHeight < c.getPreferredSize().height ? c.getPreferredSize().height : UnitTable.this.defaultHeight);
                }
                if (UnitTable.this.model instanceof LocallyDownloadedTableModel && row != -1 && !UnitTable.this.model.isCategoryAtRow(row)) {
                    c = UnitTable.this.localPluginColumn.getTableCellRendererComponent(UnitTable.this, 0, true, true, row, 1);
                    UnitTable.this.setRowHeight(row, UnitTable.this.defaultHeight < c.getPreferredSize().height ? c.getPreferredSize().height : UnitTable.this.defaultHeight);
                }
            }
        });
    }

    private void modifyBooleanEditor(int row) {
        Component cmp = this.getDefaultEditor(Boolean.class).getTableCellEditorComponent(this, 0, true, row, 0);
        if (cmp != null) {
            if (cmp instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)cmp;
                cb.setBorderPaintedFlat(true);
                cb.setVerticalAlignment(1);
            }
            cmp.setBackground(UIManager.getColor("Table.selectionBackground"));
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.model.isCategoryAtRow(row)) {
            return new CategoryTableRenderer();
        }
        return super.getCellRenderer(row, column);
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(UnitTable.class, (String)key);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader(this.columnModel);
    }

    private class BooleanRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer defaultRenderer = null;

        public BooleanRenderer(TableCellRenderer original) {
            this.defaultRenderer = original;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp == null || value == null) {
                return comp;
            }
            if (comp instanceof JCheckBox) {
                JCheckBox cb = (JCheckBox)comp;
                cb.setBorderPaintedFlat(true);
                cb.setVerticalAlignment(1);
            }
            Color c = isSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background");
            comp.setBackground(c);
            assert (value instanceof Boolean) : value + " must be instanceof Boolean.";
            comp.setEnabled(UnitTable.this.model.isCellEditable(row, 0));
            return comp;
        }
    }

    private class CategoryTableRenderer
    extends DefaultTableCellRenderer {
        private CategoryTableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (res == null || value == null) {
                return res;
            }
            assert (value instanceof UnitCategory) : value + " must be instanceof UnitCategory.";
            UnitCategory c = (UnitCategory)value;
            JLabel renderer = (JLabel)res;
            if (isSelected) {
                renderer.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                Color categoryBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
                renderer.setBackground(categoryBackground == null ? UIManager.getColor("Table.gridColor") : categoryBackground);
            }
            renderer.setText(c.getCategoryName());
            Icon treeIcon = c.isExpanded() ? openedIcon : closedIcon;
            renderer.setIcon(treeIcon);
            renderer.setHorizontalAlignment(2);
            renderer.setOpaque(true);
            res = renderer;
            return res;
        }
    }

    private class MyTableHeader
    extends JTableHeader {
        private SortColumnHeaderRenderer sortingRenderer;

        public MyTableHeader(TableColumnModel model) {
            super(model);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Object id;
                    UnitCategoryTableModel model;
                    if (e.getClickCount() != 1) {
                        return;
                    }
                    int column = MyTableHeader.this.columnAtPoint(e.getPoint());
                    if (MyTableHeader.this.sortingRenderer != null && (model = (UnitCategoryTableModel)UnitTable.this.getModel()).isSortAllowed(id = MyTableHeader.this.getColumnModel().getColumn(column).getIdentifier())) {
                        MyTableHeader.this.sortingRenderer.columnSelected(id);
                        MyTableHeader.this.repaint();
                    }
                }
            });
            this.setReorderingAllowed(false);
        }

        public void setDraggedColumn(TableColumn aColumn) {
            if (null != aColumn && aColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(aColumn);
        }

        public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
            if (!(defaultRenderer instanceof SortColumnHeaderRenderer)) {
                this.sortingRenderer = new SortColumnHeaderRenderer((UnitCategoryTableModel)UnitTable.this.getModel(), defaultRenderer);
                defaultRenderer = this.sortingRenderer;
            }
            super.setDefaultRenderer(defaultRenderer);
        }

        public void setResizingColumn(TableColumn col) {
            if (null == this.getResizingColumn() || null == col) {
                // empty if block
            }
            super.setResizingColumn(col);
        }
    }
}

