/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.List;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTableModel
extends UnitCategoryTableModel {
    private OperationContainer<InstallSupport> container = Containers.forUpdate();

    public UpdateTableModel(List<UnitCategory> categories) {
        super(categories);
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        if (col == 1) {
            return;
        }
        super.setValueAt(anValue, row, col);
        if (!this.isCategoryAtRow(row)) {
            Unit.Update u = (Unit.Update)this.getUnitAtRow(row);
            assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
            boolean beforeMarked = u.isMarked();
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
            } else {
                String message = NbBundle.getMessage(UpdateTableModel.class, (String)"NotificationAlreadyPreparedToIntsall", (Object)u.getDisplayName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        if (this.isCategoryAtRow(row)) {
            res = col == 0 ? this.getCategoryAtRow(row) : null;
        } else {
            Unit.Update u = (Unit.Update)this.getUnitAtRow(row);
            switch (col) {
                case 0: {
                    res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    res = u.getDisplayName();
                    break;
                }
                case 2: {
                    res = u.getInstalledVersion();
                    break;
                }
                case 3: {
                    res = u.getAvailableVersion();
                    break;
                }
                case 4: {
                    res = Utilities.getDownloadSizeAsString(u.getCompleteSize());
                }
            }
        }
        return res;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = DisplayName.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = String.class;
                break;
            }
            case 4: {
                res = String.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.getBundle("UpdateTableModel_Columns_Update");
            }
            case 1: {
                return this.getBundle("UpdateTableModel_Columns_Name");
            }
            case 2: {
                return this.getBundle("UpdateTableModel_Columns_Installed");
            }
            case 3: {
                return this.getBundle("UpdateTableModel_Columns_Available");
            }
            case 4: {
                return this.getBundle("UpdateTableModel_Columns_Size");
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.UPDATE;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isUpdate = this.getColumnName(0).equals(columnIdentifier);
        return !isUpdate;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (UpdateTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (UpdateTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (UpdateTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.Update.compareInstalledVersions(unit1, unit2);
                    }
                    if (UpdateTableModel.this.getColumnName(3).equals(columnIdentifier)) {
                        return Unit.Update.compareAvailableVersions(unit1, unit2);
                    }
                    if (UpdateTableModel.this.getColumnName(4).equals(columnIdentifier)) {
                        return Unit.compareCompleteSizes(unit1, unit2);
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public OperationContainer getContainer() {
        return this.container;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public class DisplayName {
        public DisplayName(String name) {
        }
    }
}

