/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static Logger logger = Logger.getLogger(Utilities.class.getName());
    private static final String UNSORTED_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Unsorted_Category");
    private static final String LIBRARIES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Libraries_Category");
    private static final String BRIDGES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Bridges_Category");

    public static List<UnitCategory> makeInstalledCategories(List<UpdateUnit> units) {
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            UpdateElement el = u.getInstalled();
            if (el == null) continue;
            String catName = el.getCategory();
            if (u.isAutoload() || u.isFixed()) {
                catName = LIBRARIES_CATEGORY;
            } else if (u.isEager()) {
                catName = BRIDGES_CATEGORY;
            } else if (catName == null || catName.length() == 0) {
                catName = UNSORTED_CATEGORY;
            }
            Unit.Installed i = new Unit.Installed(u);
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(i);
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(i);
            res.add(cat);
            names.add(catName);
        }
        Utilities.sort(res);
        logger.log(Level.FINER, "makeInstalledCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    public static List<UnitCategory> makeUpdateCategories(List<UpdateUnit> units, boolean isNbms) {
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            List updates;
            UpdateElement el = u.getInstalled();
            if (el == null || (updates = u.getAvailableUpdates()).isEmpty()) continue;
            String catName = el.getCategory();
            if (catName == null || catName.length() == 0) {
                catName = UNSORTED_CATEGORY;
            }
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(new Unit.Update(u, isNbms));
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(new Unit.Update(u, isNbms));
            res.add(cat);
            names.add(catName);
        }
        Utilities.sort(res);
        logger.log(Level.FINER, "makeUpdateCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    public static List<UnitCategory> makeAvailableCategories(List<UpdateUnit> units, boolean isNbms) {
        ArrayList<UnitCategory> res = new ArrayList<UnitCategory>();
        ArrayList<String> names = new ArrayList<String>();
        for (UpdateUnit u : units) {
            UnitCategory cat;
            List updates;
            UpdateElement el = u.getInstalled();
            if (el != null || (updates = u.getAvailableUpdates()) == null || updates.size() == 0) continue;
            UpdateElement upEl = (UpdateElement)updates.get(0);
            String catName = upEl.getCategory();
            if (catName == null || catName.length() == 0) {
                catName = UNSORTED_CATEGORY;
            }
            if (names.contains(catName)) {
                cat = (UnitCategory)res.get(names.indexOf(catName));
                cat.addUnit(new Unit.Available(u, isNbms));
                continue;
            }
            cat = new UnitCategory(catName);
            cat.addUnit(new Unit.Available(u, isNbms));
            res.add(cat);
            names.add(catName);
        }
        Utilities.sort(res);
        logger.log(Level.FINER, "makeAvailableCategories (" + units.size() + ") returns " + res.size());
        return res;
    }

    public static void showURL(URL href) {
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (displayer != null) {
            displayer.showURL(href);
        } else {
            logger.log(Level.INFO, "No URLDisplayer found.");
        }
    }

    public static List<UpdateElement> getRequiredElements(UpdateUnit unit, UpdateElement el, OperationContainer<OperationSupport> container) {
        List<UpdateElement> reqs = Collections.emptyList();
        if (container.canBeAdded(unit, el)) {
            OperationContainer.OperationInfo info = container.add(unit, el);
            reqs = new LinkedList<UpdateElement>(info.getRequiredElements());
        }
        return reqs;
    }

    private static void sort(List<UnitCategory> res) {
        final Collator collator = Collator.getInstance();
        final Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (LIBRARIES_CATEGORY == o1) {
                    if (LIBRARIES_CATEGORY == o2) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == LIBRARIES_CATEGORY) {
                    return -1;
                }
                if (BRIDGES_CATEGORY == o1) {
                    if (BRIDGES_CATEGORY == o2) {
                        return 0;
                    }
                    return 1;
                }
                if (BRIDGES_CATEGORY == o2) {
                    return -1;
                }
                if (UNSORTED_CATEGORY == o1) {
                    if (UNSORTED_CATEGORY == o2) {
                        return 0;
                    }
                    return 1;
                }
                if (UNSORTED_CATEGORY == o2) {
                    return -1;
                }
                return collator.compare(o1, o2);
            }
        };
        Collections.sort(res, new Comparator<UnitCategory>(){

            @Override
            public int compare(UnitCategory o1, UnitCategory o2) {
                return comparator.compare(o1.getCategoryName(), o2.getCategoryName());
            }
        });
        for (UnitCategory unitCategory : res) {
            Collections.sort(unitCategory.units, new Comparator<Unit>(){

                @Override
                public int compare(Unit u1, Unit u2) {
                    return collator.compare(u1.getDisplayName(), u2.getDisplayName());
                }
            });
        }
    }

    public static boolean isGtk() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    public static String getDownloadSizeAsString(int size) {
        int gbSize = size / 0x40000000;
        if (gbSize > 0) {
            return gbSize + Utilities.getBundle("Utilities_DownloadSize_GB");
        }
        int mbSize = size / 0x100000;
        if (mbSize > 0) {
            return mbSize + Utilities.getBundle("Utilities_DownloadSize_MB");
        }
        int kbSize = size / 1024;
        if (kbSize > 0) {
            return kbSize + Utilities.getBundle("Utilities_DownloadSize_kB");
        }
        return size + Utilities.getBundle("Utilities_DownloadSize_B");
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(Utilities.class, (String)key);
    }

    public static void presentRefreshProvider(UpdateUnitProvider provider, PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(Collections.singleton(provider), manager, force);
    }

    public static void presentRefreshProviders(Collection<UpdateUnitProvider> providers, PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(providers, manager, force);
    }

    public static void presentRefreshProviders(PluginManagerUI manager, boolean force) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProviders() call in EQ!";
        Utilities.doRefreshProviders(UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true), manager, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRefreshProviders(Collection<UpdateUnitProvider> providers, PluginManagerUI manager, boolean force) {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)"refresh-providers-handle");
        JComponent progressComp = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JLabel detailLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        detailLabel.setHorizontalAlignment(4);
        try {
            manager.setProgressComponent(detailLabel, progressComp);
            handle.setInitialDelay(0);
            handle.start();
            for (UpdateUnitProvider p : providers) {
                p.refresh(handle, force);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, ioe.getMessage(), ioe);
            if (handle != null) {
                handle.finish();
            }
            NetworkProblemPanel.showNetworkProblemDialog();
        }
        finally {
            if (handle != null) {
                handle.finish();
            }
            Containers.initNotify();
            manager.unsetProgressComponent(detailLabel, progressComp);
        }
    }
}

