/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallUnitWizardModel
extends OperationWizardModel {
    private InstallSupport.Installer installer = null;
    private boolean doUpdate;
    private static Set<String> approvedLicences = new HashSet<String>();
    private OperationContainer installContainer;
    private InstallSupport support;

    public InstallUnitWizardModel(OperationContainer container) {
        this.doUpdate = container == Containers.forUpdate() || container == Containers.forUpdateNbms();
        this.installContainer = container;
        this.support = (InstallSupport)this.installContainer.getSupport();
        assert (this.support != null);
        assert (!this.doUpdate ? Containers.forAvailable() != null : Containers.forUpdate() != null) : "The container must exist!";
    }

    @Override
    public OperationWizardModel.OperationType getOperation() {
        return this.doUpdate ? OperationWizardModel.OperationType.UPDATE : OperationWizardModel.OperationType.INSTALL;
    }

    @Override
    public OperationContainer getContainer() {
        return this.installContainer;
    }

    public boolean allLicensesApproved() {
        for (UpdateElement el : this.getAllUpdateElements()) {
            if (approvedLicences.contains(el.getLicence())) continue;
            return false;
        }
        return true;
    }

    public void addApprovedLicenses(Collection<String> licences) {
        approvedLicences.addAll(licences);
    }

    public InstallSupport getSupport() {
        return this.support;
    }

    public void setInstaller(InstallSupport.Installer i) {
        this.installer = i;
    }

    public InstallSupport.Installer getInstaller() {
        return this.installer;
    }

    public void doCleanup() throws OperationException {
        assert (this.getContainer() != null);
        InstallSupport supp = this.getSupport();
        if (supp != null) {
            supp.doCancel();
        }
    }
}

