/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceWatcher {
    private List<Reference<Object>> references = new ArrayList<Reference<Object>>();
    private ReferenceQueue<Object> queue = new ReferenceQueue();
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private transient List<WeakReference<ChangeListener>> changeListenerList;

    public InstanceWatcher() {
        new FinalizingToken();
    }

    public synchronized void add(Object instance) {
        if (!this.contains(instance)) {
            this.references.add(new WeakReference<Object>(instance, this.queue));
        }
    }

    private synchronized boolean contains(Object o) {
        for (Reference<Object> r : this.references) {
            if (r.get() != o) continue;
            return true;
        }
        return false;
    }

    public synchronized int size() {
        this.removeNulls();
        return this.references.size();
    }

    public Collection<?> getInstances() {
        ArrayList<Object> l = new ArrayList<Object>(this.references.size());
        for (Reference<Object> wr : this.references) {
            Object inst = wr.get();
            if (inst == null) continue;
            l.add(inst);
        }
        return l;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList<WeakReference<ChangeListener>>();
        }
        this.changeListenerList.add(new WeakReference<ChangeListener>(listener));
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListenerList != null) {
            for (WeakReference<ChangeListener> r : this.changeListenerList) {
                if (!listener.equals(r.get())) continue;
                this.changeListenerList.remove(r);
            }
        }
    }

    private static <T> void cleanAndCopy(List<? extends Reference<T>> src, List<? super T> dest) {
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i).get();
            if (o == null) {
                src.remove(i);
                continue;
            }
            if (dest == null) continue;
            dest.add(0, o);
        }
    }

    private synchronized void removeNulls() {
        InstanceWatcher.cleanAndCopy(this.references, null);
    }

    private boolean cleanQueue() {
        boolean retValue = false;
        while (this.queue.poll() != null) {
            retValue = true;
        }
        return retValue;
    }

    private void refresh() {
        if (this.cleanQueue()) {
            this.removeNulls();
            this.fireChangeListenerStateChanged();
        }
        new FinalizingToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged() {
        LinkedList list = new LinkedList();
        InstanceWatcher instanceWatcher = this;
        synchronized (instanceWatcher) {
            if (this.changeListenerList == null) {
                return;
            }
            InstanceWatcher.cleanAndCopy(this.changeListenerList, list);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener ch : list) {
            ch.stateChanged(e);
        }
    }

    private class FinalizingToken
    implements Runnable {
        private FinalizingToken() {
        }

        public void finalize() {
            executor.submit(this);
        }

        public void run() {
            InstanceWatcher.this.refresh();
        }
    }
}

