/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.modules.timers.TimesCollectorPeer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class TimeComponentPanel
extends JPanel
implements PropertyChangeListener {
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable times;
    private Map<String, Integer> key2RowNumber;

    public TimeComponentPanel() {
        this.initComponents();
        this.times.addMouseListener((MouseListener)((Object)new PopupAdapter()));
        this.jList1.addMouseListener((MouseListener)((Object)new ListPopupAdapter()));
        this.key2RowNumber = new HashMap<String, Integer>();
        TimesCollectorPeer.getDefault().addPropertyChangeListener(this);
        this.fillIn();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.times = new JTable();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(8);
        this.jSplitPane1.setOrientation(0);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new FileObjectListRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TimeComponentPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.times.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Time"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Long.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.times);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.fillTimeTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTimeTable() {
        Collection<String> keys;
        Object fo = this.jList1.getSelectedValue();
        DefaultTableModel model = (DefaultTableModel)this.times.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        this.key2RowNumber.clear();
        Collection<String> collection = keys = TimesCollectorPeer.getDefault().getKeysForFile(fo);
        synchronized (collection) {
            for (String key : keys) {
                this.changeRow(fo, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimesCollectorPeer.Description getDescForRow(Object fo, int row) {
        Collection<String> keys;
        Collection<String> collection = keys = TimesCollectorPeer.getDefault().getKeysForFile(fo);
        synchronized (collection) {
            Iterator<String> it = keys.iterator();
            String key = null;
            for (int i = 0; i <= row; ++i) {
                assert (it.hasNext());
                key = it.next();
            }
            return TimesCollectorPeer.getDefault().getDescription(fo, key);
        }
    }

    private void changeRow(Object fo, String key) {
        TimesCollectorPeer.Description desc;
        Integer row = this.key2RowNumber.get(key);
        DefaultTableModel model = (DefaultTableModel)this.times.getModel();
        if (row != null) {
            model.removeRow(row);
        }
        if ((desc = TimesCollectorPeer.getDefault().getDescription(fo, key)) == null) {
            return;
        }
        if (row == null) {
            row = model.getRowCount();
            this.key2RowNumber.put(key, row);
        }
        model.insertRow((int)row, new Object[]{desc.getMessage(), desc.getTime()});
    }

    private void fillIn() {
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        model.removeAllElements();
        for (Object f : TimesCollectorPeer.getDefault().getFiles()) {
            model.addElement(f);
        }
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object fo;
                if ("fos".equals(evt.getPropertyName())) {
                    DefaultListModel model = (DefaultListModel)TimeComponentPanel.this.jList1.getModel();
                    if (evt.getNewValue() != null) {
                        model.addElement(evt.getNewValue());
                    } else {
                        TimeComponentPanel.this.fillIn();
                    }
                }
                if ("PROP".equals(evt.getPropertyName())) {
                    fo = evt.getOldValue();
                    String key = (String)evt.getNewValue();
                    if (fo == TimeComponentPanel.this.jList1.getSelectedValue() || fo == null) {
                        TimeComponentPanel.this.changeRow(fo, key);
                    }
                }
                if ("selected".equals(evt.getPropertyName())) {
                    fo = evt.getNewValue();
                    TimeComponentPanel.this.jList1.setSelectedValue(fo, true);
                }
            }
        });
    }

    private static void dumpRoots(Collection objs) {
        JPanel inner = new JPanel();
        inner.setLayout(new BorderLayout());
        JProgressBar bar = new JProgressBar();
        inner.add((Component)new JLabel("Computing object reachability"), "Center");
        inner.add((Component)bar, "South");
        Dialog d = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)inner, "Please wait"));
        d.pack();
        d.setModal(false);
        d.setVisible(true);
        String report = TimeComponentPanel.getRoots(objs, bar, inner);
        inner.removeAll();
        JScrollPane pane = new JScrollPane();
        JTextArea editor = new JTextArea(report);
        editor.setColumns(80);
        editor.setEditable(false);
        pane.setViewportView(editor);
        inner.add((Component)pane, "Center");
        d.setSize(Math.min(600, editor.getPreferredSize().width + 30), Math.min(400, editor.getPreferredSize().height + 70));
        d.invalidate();
        d.validate();
        d.repaint();
    }

    private static String getRoots(Collection objects, JProgressBar bar, final JPanel inner) {
        bar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                inner.paintImmediately(inner.getBounds());
            }
        });
        Map traces = LiveReferences.fromRoots(objects, null, bar.getModel());
        StringBuffer sb = new StringBuffer();
        for (Object inst : traces.keySet()) {
            sb.append(inst);
            sb.append(":\n");
            sb.append(traces.get(inst));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private static class FileObjectListRenderer
    extends DefaultListCellRenderer {
        private NodeRenderer r = new NodeRenderer();

        private FileObjectListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof FileObject) {
                try {
                    FileObject fo = (FileObject)value;
                    DataObject od = DataObject.find((FileObject)fo);
                    Node node = od.getNodeDelegate();
                    return this.r.getListCellRendererComponent(list, (Object)node, index, isSelected, cellHasFocus);
                }
                catch (IOException e) {
                    value = "<error>";
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    class ListPopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        ListPopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TimeComponentPanel.this.jList1.locationToIndex(e.getPoint());
            if (!TimeComponentPanel.this.jList1.isSelectedIndex(selRow)) {
                TimeComponentPanel.this.jList1.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TimeComponentPanel.this);
                this.createPopup((int)p.getX(), (int)p.getY(), selRow);
            }
        }

        void createPopup(int x, int y, int row) {
            final Object[] fo = new Object[]{TimeComponentPanel.this.jList1.getSelectedValue()};
            if (!(fo[0] instanceof FileObject)) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction("Find refs"){

                public void actionPerformed(ActionEvent arg0) {
                    try {
                        FileObject f = (FileObject)fo[0];
                        fo[0] = null;
                        TimeComponentPanel.dumpRoots(Collections.singleton(DataObject.find((FileObject)f)));
                    }
                    catch (DataObjectNotFoundException ex) {
                        Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
            popup.show(TimeComponentPanel.this, x, y);
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TimeComponentPanel.this.times.rowAtPoint(e.getPoint());
            if (!TimeComponentPanel.this.times.isRowSelected(selRow)) {
                TimeComponentPanel.this.times.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TimeComponentPanel.this);
                this.createPopup((int)p.getX(), (int)p.getY(), selRow);
            }
        }

        void createPopup(int x, int y, int row) {
            Object fo = TimeComponentPanel.this.jList1.getSelectedValue();
            TimesCollectorPeer.Description desc = TimeComponentPanel.this.getDescForRow(fo, row);
            if (!(desc instanceof TimesCollectorPeer.ObjectCountDescripton)) {
                return;
            }
            final TimesCollectorPeer.ObjectCountDescripton oc = (TimesCollectorPeer.ObjectCountDescripton)desc;
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction("Find refs"){

                public void actionPerformed(ActionEvent arg0) {
                    TimeComponentPanel.dumpRoots(oc.getInstances());
                }
            });
            popup.show(TimeComponentPanel.this, x, y);
        }
    }
}

