/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.openide.actions.HeapView;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

public class GarbageCollectAction
extends CallableSystemAction {
    public String getName() {
        return NbBundle.getBundle(GarbageCollectAction.class).getString("CTL_GarbageCollect");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GarbageCollectAction.class);
    }

    public void performAction() {
        GarbageCollectAction.gc();
    }

    private static void gc() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                System.gc();
                System.runFinalization();
                System.gc();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public Component getToolbarPresenter() {
        return new HeapViewWrapper();
    }

    private static final class HeapViewWrapper
    extends JComponent {
        public HeapViewWrapper() {
            this.add(new HeapView());
            this.setLayout(null);
        }

        public boolean isOpaque() {
            return false;
        }

        public Dimension getMinimumSize() {
            return this.calcPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.calcPreferredSize();
        }

        public Dimension getMaximumSize() {
            Dimension pref = this.calcPreferredSize();
            Container parent = this.getParent();
            if (parent != null && parent.getHeight() > 0) {
                pref.height = parent.getHeight();
            }
            return pref;
        }

        public Dimension calcPreferredSize() {
            Dimension pref = this.getHeapView().heapViewPreferredSize();
            ++pref.height;
            pref.width += 6;
            return pref;
        }

        public void layout() {
            int w = this.getWidth();
            int h = this.getHeight();
            HeapView heapView = this.getHeapView();
            heapView.setBounds(4, 2, w - 6, h - 4);
        }

        private HeapView getHeapView() {
            return (HeapView)this.getComponent(0);
        }
    }
}

