/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.actions.ActionManager;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JMenuPlus;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static G gl;

    private static synchronized G gl() {
        if (gl == null) {
            gl = new G();
        }
        return gl;
    }

    public String getName() {
        return ToolsAction.getActionName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolsAction.class);
    }

    public JMenuItem getMenuPresenter() {
        return new Inline((Action)((Object)this));
    }

    public JMenuItem getPopupPresenter() {
        return new Popup((Action)((Object)this));
    }

    public void actionPerformed(ActionEvent ev) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    private static String getActionName() {
        return NbBundle.getMessage(ToolsAction.class, (String)"CTL_Tools");
    }

    /*
     * WARNING - void declaration
     */
    private static List<JMenuItem> generate(Action toolsAction, boolean forMenu) {
        ActionManager am = ActionManager.getDefault();
        SystemAction[] actions = am.getContextActions();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>(actions.length);
        boolean separator = false;
        boolean firstItemAdded = false;
        Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)toolsAction).getLookup() : null;
        for (SystemAction systemAction : actions) {
            JMenuItem mi;
            void var11_11;
            if (lookup != null && systemAction instanceof ContextAwareAction) {
                Action action = ((ContextAwareAction)systemAction).createContextAwareInstance(lookup);
            }
            if (var11_11 == null) {
                if (!firstItemAdded) continue;
                separator = true;
                continue;
            }
            boolean isPopup = var11_11 instanceof Presenter.Popup;
            boolean isMenu = var11_11 instanceof Presenter.Menu;
            if (!(forMenu && isMenu || !forMenu && isPopup) && (isMenu || isPopup) || !var11_11.isEnabled()) continue;
            if (forMenu && isMenu) {
                mi = ((Presenter.Menu)var11_11).getMenuPresenter();
            } else if (!forMenu && isPopup) {
                mi = ((Presenter.Popup)var11_11).getPopupPresenter();
            } else {
                if (isMenu || isPopup) continue;
                mi = new JMenuItem();
                Actions.connect((JMenuItem)mi, (Action)var11_11, (!forMenu ? 1 : 0) != 0);
            }
            if (separator) {
                list.add(null);
                separator = false;
            }
            list.add(mi);
            firstItemAdded = true;
        }
        return list;
    }

    @Deprecated
    public static void setModel(Model m) {
        throw new SecurityException();
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Lookup.Provider {
        private ToolsAction delegate;
        private Lookup lookup;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(ToolsAction delegate, Lookup actionContext) {
            this.delegate = delegate;
            this.lookup = actionContext;
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void putValue(String key, Object o) {
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public JMenuItem getMenuPresenter() {
            return new Inline(this);
        }

        public JMenuItem getPopupPresenter() {
            return new Popup(this);
        }
    }

    private static class G
    implements PropertyChangeListener {
        public static final String PROP_STATE = "actionsState";
        private int timestamp = 1;
        private SystemAction[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);

        public G() {
            ActionManager am = ActionManager.getDefault();
            am.addPropertyChangeListener(this);
            this.actionsListChanged();
        }

        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            this.supp.addPropertyChangeListener(listener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            this.supp.removePropertyChangeListener(listener);
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            this.supp.firePropertyChange(name, o, n);
        }

        private void actionsListChanged() {
            ++this.timestamp;
            SystemAction[] copy = this.actions;
            if (copy != null) {
                for (int i = 0; i < copy.length; ++i) {
                    SystemAction act = copy[i];
                    if (act == null) continue;
                    act.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            ActionManager am = ActionManager.getDefault();
            copy = am.getContextActions();
            for (int i = 0; i < copy.length; ++i) {
                SystemAction act = copy[i];
                if (act == null) continue;
                act.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.actions = copy;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("contextActions")) {
                this.actionsListChanged();
            } else if (prop.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled(Action toolsAction) {
            boolean en = false;
            SystemAction[] copy = this.actions;
            Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)toolsAction).getLookup() : null;
            for (int i = 0; i < copy.length; ++i) {
                Object act = lookup != null && copy[i] instanceof ContextAwareAction ? ((ContextAwareAction)copy[i]).createContextAwareInstance(lookup) : copy[i];
                if (!(act instanceof Presenter.Popup) || !act.isEnabled()) continue;
                en = true;
                break;
            }
            return en;
        }

        private int getTimestamp() {
            return this.timestamp;
        }
    }

    private static final class Inline
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;
        private Action toolsAction;

        Inline(Action toolsAction) {
            this.toolsAction = toolsAction;
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            if (this.timestamp == ToolsAction.gl().getTimestamp()) {
                return items;
            }
            List l = ToolsAction.generate(this.toolsAction, true);
            this.timestamp = ToolsAction.gl().getTimestamp();
            return l.toArray(new JMenuItem[l.size()]);
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }
    }

    @Deprecated
    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private static final class Popup
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private Action toolsAction;

        public Popup(Action toolsAction) {
            this.toolsAction = toolsAction;
            HelpCtx.setHelpIDString((JComponent)this.menu, (String)ToolsAction.class.getName());
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            JComponent[] jComponentArray;
            if (ToolsAction.gl().isPopupEnabled(this.toolsAction)) {
                JMenuItem[] jMenuItemArray = new JMenuItem[1];
                jComponentArray = jMenuItemArray;
                jMenuItemArray[0] = this.menu;
            } else {
                jComponentArray = new JMenuItem[]{};
            }
            return jComponentArray;
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup;

            MyMenu() {
                super(ToolsAction.getActionName());
                this.lastPopup = null;
            }

            public JPopupMenu getPopupMenu() {
                JPopupMenu popup = super.getPopupMenu();
                this.fillSubmenu(popup);
                return popup;
            }

            private void fillSubmenu(JPopupMenu pop) {
                if (this.lastPopup == null) {
                    pop.addPopupMenuListener(this);
                    this.lastPopup = pop;
                    this.removeAll();
                    for (Component item : ToolsAction.generate(Popup.this.toolsAction, false)) {
                        if (item == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(item);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        JMenuItem empty = new JMenuItem(NbBundle.getMessage(ToolsAction.class, (String)"CTL_EmptySubMenu"));
                        empty.setEnabled(false);
                        this.add(empty);
                    }
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.lastPopup.removePopupMenuListener(this);
                this.lastPopup = null;
            }
        }
    }
}

