/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import org.openide.actions.RedoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UndoAction
extends CallableSystemAction {
    private static Listener listener;
    private static UndoRedo last;
    private static String SWING_DEFAULT_LABEL;
    private static UndoAction undoAction;
    private static RedoAction redoAction;

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    static synchronized void initializeUndoRedo() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        TopComponent.Registry r = WindowManager.getDefault().getRegistry();
        r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)r));
        last = UndoAction.getUndoRedo();
        last.addChangeListener((ChangeListener)listener);
        UndoAction.updateStatus();
    }

    static synchronized void updateStatus() {
        if (undoAction == null) {
            undoAction = (UndoAction)UndoAction.findObject(UndoAction.class, (boolean)false);
        }
        if (redoAction == null) {
            redoAction = (RedoAction)UndoAction.findObject(RedoAction.class, (boolean)false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UndoRedo ur = UndoAction.getUndoRedo();
                if (undoAction != null) {
                    undoAction.setEnabled(ur.canUndo());
                }
                if (redoAction != null) {
                    redoAction.setEnabled(ur.canRedo());
                }
            }
        });
    }

    static UndoRedo getUndoRedo() {
        TopComponent el = WindowManager.getDefault().getRegistry().getActivated();
        return el == null ? UndoRedo.NONE : el.getUndoRedo();
    }

    public String getName() {
        String undo = UndoAction.getUndoRedo().getUndoPresentationName();
        Logger.getLogger(UndoAction.class.getName()).log(Level.FINE, "getUndoRedo().getUndoPresentationName() returns " + undo);
        Logger.getLogger(UndoAction.class.getName()).log(Level.FINE, "SWING_DEFAULT_LABEL is " + SWING_DEFAULT_LABEL);
        if (undo != null && SWING_DEFAULT_LABEL != null && undo.startsWith(SWING_DEFAULT_LABEL)) {
            undo = undo.substring(SWING_DEFAULT_LABEL.length()).trim();
        }
        Logger.getLogger(UndoAction.class.getName()).log(Level.FINE, "Name adapted by SWING_DEFAULT_LABEL is " + undo);
        String presentationName = NbBundle.getMessage(UndoAction.class, (String)"Undo", (Object)undo);
        Logger.getLogger(UndoAction.class.getName()).log(Level.FINE, "Result name is " + presentationName);
        return presentationName;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UndoAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/undo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canUndo()) {
                undoRedo.undo();
            }
        }
        catch (CannotUndoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        UndoAction.updateStatus();
    }

    protected boolean asynchronous() {
        return false;
    }

    static {
        last = UndoRedo.NONE;
        SWING_DEFAULT_LABEL = UIManager.getString("AbstractUndoableEdit.undoText");
        undoAction = null;
        redoAction = null;
    }

    private static final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            UndoAction.updateStatus();
            last.removeChangeListener((ChangeListener)this);
            last = UndoAction.getUndoRedo();
            last.addChangeListener((ChangeListener)this);
        }

        public void stateChanged(ChangeEvent ev) {
            UndoAction.updateStatus();
        }
    }
}

