/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.lexer.CharPreprocessorError;
import org.netbeans.lib.lexer.CharPreprocessorOperation;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.PreprocessedTextStorage;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.ComplexToken;
import org.netbeans.lib.lexer.token.PreprocessedTextToken;
import org.netbeans.spi.lexer.CharPreprocessor;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerInputOperation<T extends TokenId>
implements CharProvider {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private int readIndex;
    private int lookaheadIndex;
    private CharPreprocessorOperation preprocessorOperation;
    private int tokenLength;
    private final TokenList<T> tokenList;
    private final boolean mutableInput;
    private final Lexer<T> lexer;
    private int tokenStartIndex;
    private boolean lexerFinished;
    private int flySequenceLength;
    private List<CharPreprocessorError> preprocessErrorList;
    protected int preprocessingLevelCount;
    private CharProvider.ExtraPreprocessedChars extraPreprocessedChars;

    public LexerInputOperation(TokenList<T> tokenList, int tokenIndex, Object lexerRestartState) {
        this.tokenList = tokenList;
        boolean bl = this.mutableInput = tokenList.modCount() != -1;
        while (--tokenIndex >= 0 && LexerUtilsConstants.token(tokenList, tokenIndex).isFlyweight()) {
            ++this.flySequenceLength;
        }
        LanguagePath languagePath = tokenList.languagePath();
        LanguageOperation languageOperation = LexerUtilsConstants.mostEmbeddedLanguageOperation(languagePath);
        TokenFactory tokenFactory = LexerSpiPackageAccessor.get().createTokenFactory(this);
        CharPreprocessor p = LexerSpiPackageAccessor.get().createCharPreprocessor(languageOperation.languageHierarchy());
        if (p != null) {
            ++this.preprocessingLevelCount;
            this.preprocessorOperation = new CharPreprocessorOperation(this.preprocessorOperation != null ? this.preprocessorOperation : this, p, this);
        }
        LexerInput lexerInput = LexerSpiPackageAccessor.get().createLexerInput(this.preprocessorOperation != null ? this.preprocessorOperation : this);
        LexerRestartInfo info = LexerSpiPackageAccessor.get().createLexerRestartInfo(lexerInput, tokenFactory, lexerRestartState, tokenList.languagePath(), this.inputAttributes());
        this.lexer = LexerSpiPackageAccessor.get().createLexer(languageOperation.languageHierarchy(), info);
    }

    public abstract int read(int var1);

    @Override
    public abstract char readExisting(int var1);

    public abstract void approveToken(AbstractToken<T> var1);

    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    @Override
    public final int read() {
        int c;
        if ((c = this.read(this.readIndex++)) == -1) {
            this.lookaheadIndex = this.readIndex--;
        }
        return c;
    }

    @Override
    public int deepRawLength(int length) {
        return length;
    }

    @Override
    public int deepRawLengthShift(int index) {
        return index;
    }

    @Override
    public final int readIndex() {
        return this.readIndex;
    }

    @Override
    public final void backup(int count) {
        if (this.lookaheadIndex < this.readIndex) {
            this.lookaheadIndex = this.readIndex;
        }
        this.readIndex -= count;
    }

    public final int lookahead() {
        return this.lookaheadIndex > this.readIndex ? (this.preprocessorOperation != null ? this.preprocessorOperation.deepRawLength(this.lookaheadIndex - this.readIndex) : this.lookaheadIndex - this.readIndex) : 0;
    }

    @Override
    public final int tokenLength() {
        return this.tokenLength;
    }

    @Override
    public void tokenRecognized(int tokenLength) {
        if (tokenLength > this.readIndex()) {
            throw new IndexOutOfBoundsException("tokenLength=" + tokenLength + " >" + this.readIndex());
        }
        this.tokenLength = tokenLength;
    }

    @Override
    public void tokenApproved() {
        this.tokenStartIndex += this.tokenLength;
        this.readIndex -= this.tokenLength;
        this.lookaheadIndex -= this.tokenLength;
    }

    protected final TokenList<T> tokenList() {
        return this.tokenList;
    }

    protected final int tokenStartIndex() {
        return this.tokenStartIndex;
    }

    public final void setTokenStartIndex(int tokenStartIndex) {
        this.tokenStartIndex = tokenStartIndex;
    }

    protected final CharPreprocessorOperation preprocessor() {
        return this.preprocessorOperation;
    }

    public final boolean isMutableInput() {
        return this.mutableInput;
    }

    public final boolean isStoreLookaheadAndState() {
        return this.isMutableInput() || testing;
    }

    public AbstractToken<T> nextToken() {
        AbstractToken token;
        assert (!this.lexerFinished);
        do {
            if ((token = (AbstractToken)this.lexer().nextToken()) == null) {
                LexerUtilsConstants.checkLexerInputFinished(this.preprocessorOperation != null ? this.preprocessorOperation : this, this);
                this.lexerFinished = true;
                return null;
            }
            this.approveToken(token);
        } while (token == TokenFactory.SKIP_TOKEN);
        return token;
    }

    public final boolean tokenRecognized(int tokenLength, boolean skip) {
        if (this.preprocessorOperation != null) {
            this.preprocessorOperation.tokenRecognized(tokenLength);
        } else {
            this.tokenRecognized(tokenLength);
        }
        if (!skip && tokenLength != this.tokenLength || this.preprocessErrorList != null && this.preprocessErrorList.get(0).index() < this.tokenLength) {
            if (this.extraPreprocessedChars == null && this.preprocessingLevelCount > 1) {
                this.extraPreprocessedChars = new CharProvider.ExtraPreprocessedChars();
            }
            return true;
        }
        return false;
    }

    public void notifyPreprocessorError(CharPreprocessorError error) {
        if (this.preprocessErrorList == null) {
            this.preprocessErrorList = new GapList();
        }
        this.preprocessErrorList.add(error);
    }

    public final void initPreprocessedToken(AbstractToken<T> token) {
        CharPreprocessorError error = null;
        if (this.preprocessErrorList != null && this.preprocessErrorList.size() > 0) {
            for (int i = this.preprocessErrorList.size() - 1; i >= 0; --i) {
                error = this.preprocessErrorList.get(i);
                if (error.index() < this.tokenLength) {
                    this.preprocessErrorList.remove(i);
                    continue;
                }
                error.updateIndex(-this.tokenLength);
                error = null;
            }
        }
        PreprocessedTextStorage storage = this.preprocessorOperation.createPreprocessedTextStorage(token.text(), this.extraPreprocessedChars);
        if (token.getClass() == ComplexToken.class) {
            ((ComplexToken)token).initPrep(storage, error);
        } else {
            ((PreprocessedTextToken)token).initPrep(storage, error);
        }
    }

    @Override
    public void collectExtraPreprocessedChars(CharProvider.ExtraPreprocessedChars epc, int prepStartIndex, int prepEndIndex, int topPrepEndIndex) {
    }

    public final LanguageOperation<T> languageOperation() {
        return LexerUtilsConstants.mostEmbeddedLanguageOperation(this.tokenList.languagePath());
    }

    public final Object lexerState() {
        return this.lexer.state();
    }

    public final boolean isFlyTokenAllowed() {
        return this.flySequenceLength < 5;
    }

    protected final void flyTokenAdded() {
        ++this.flySequenceLength;
    }

    protected final void preventFlyToken() {
        this.flySequenceLength = 5;
    }

    protected final void clearFlySequence() {
        this.flySequenceLength = 0;
    }

    protected final boolean isSkipToken(AbstractToken<T> token) {
        return token == TokenFactory.SKIP_TOKEN;
    }

    public final Lexer lexer() {
        return this.lexer;
    }

    public final InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    public final void release() {
        this.lexer.release();
    }
}

