/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.FilterSnapshotTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LexerUtilsConstants {
    public static final int MAX_FLY_SEQUENCE_LENGTH = 5;
    public static final int MIN_LEXED_AREA_LENGTH = 4096;
    public static final int LEXED_AREA_INPUT_SIZE_FRACTION = 10;

    public static void checkLexerInputFinished(CharProvider input, LexerInputOperation operation) {
        if (input.read() != -1) {
            throw new IllegalStateException("Lexer " + operation.lexer() + " returned null token" + " but EOF was not read from lexer input yet." + " Fix the lexer.");
        }
        if (input.readIndex() > 0) {
            throw new IllegalStateException("Lexer " + operation.lexer() + " returned null token but lexerInput.readLength()=" + input.readIndex() + " - these characters need to be tokenized." + " Fix the lexer.");
        }
    }

    public static void tokenLengthZeroOrNegative(int tokenLength) {
        if (tokenLength == 0) {
            throw new IllegalArgumentException("Tokens with zero length are not supported by the framework. Fix the lexer.");
        }
        throw new IllegalArgumentException("Negative token length " + tokenLength);
    }

    public static void throwFlyTokenProhibited() {
        throw new IllegalStateException("Flyweight token created but prohibited. Lexer needs to check lexerInput.isFlyTokenAllowed().");
    }

    public static void throwBranchTokenFlyProhibited(AbstractToken token) {
        throw new IllegalStateException("Language embedding cannot be created for flyweight token=" + token + "\nFix the lexer to not create flyweight token instance when" + " language embedding exists for the token.");
    }

    public static void checkValidBackup(int count, int maxCount) {
        if (count > maxCount) {
            throw new IndexOutOfBoundsException("Cannot backup " + count + " characters. Maximum: " + maxCount + '.');
        }
    }

    public static <T extends TokenId> LanguageHierarchy<T> languageHierarchy(Language<T> language) {
        return LexerApiPackageAccessor.get().languageHierarchy(language);
    }

    public static <T extends TokenId> LanguageOperation<T> languageOperation(Language<T> language) {
        return LexerSpiPackageAccessor.get().operation(LexerUtilsConstants.languageHierarchy(language));
    }

    public static <T extends TokenId> Language<T> mostEmbeddedLanguage(LanguagePath languagePath) {
        Language<? extends TokenId> l = languagePath.innerLanguage();
        return l;
    }

    public static <T extends TokenId> LanguageHierarchy<T> mostEmbeddedLanguageHierarchy(LanguagePath languagePath) {
        LanguageHierarchy<? extends TokenId> lh = LexerUtilsConstants.languageHierarchy(languagePath.innerLanguage());
        return lh;
    }

    public static <T extends TokenId> LanguageOperation<T> mostEmbeddedLanguageOperation(LanguagePath languagePath) {
        LanguageOperation<T> lo = LexerSpiPackageAccessor.get().operation(LexerUtilsConstants.mostEmbeddedLanguageHierarchy(languagePath));
        return lo;
    }

    public static <T extends TokenId> LanguageEmbedding<? extends TokenId> findEmbedding(Token<T> token, LanguagePath languagePath, InputAttributes inputAttributes) {
        LanguageHierarchy<T> languageHierarchy = LexerUtilsConstants.mostEmbeddedLanguageHierarchy(languagePath);
        LanguageEmbedding<TokenId> embedding = LexerSpiPackageAccessor.get().embedding(languageHierarchy, token, languagePath, inputAttributes);
        if (embedding == null) {
            embedding = LanguageManager.getInstance().findLanguageEmbedding(token, languagePath, inputAttributes);
        }
        return embedding;
    }

    public static <T extends TokenId> AbstractToken<T> token(Object tokenOrEmbeddingContainer) {
        AbstractToken token = tokenOrEmbeddingContainer.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)tokenOrEmbeddingContainer).token() : (AbstractToken)tokenOrEmbeddingContainer;
        return token;
    }

    public static <T extends TokenId> AbstractToken<T> token(TokenList<T> tokenList, int index) {
        return LexerUtilsConstants.token(tokenList.tokenOrEmbeddingContainer(index));
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder sb, TokenList<T> tokenList, int currentIndex) {
        return LexerUtilsConstants.appendTokenList(sb, tokenList, currentIndex, 0, Integer.MAX_VALUE);
    }

    public static <T extends TokenId> StringBuilder appendTokenList(StringBuilder sb, TokenList<T> tokenList, int currentIndex, int startIndex, int endIndex) {
        TokenHierarchy<?> tokenHierarchy;
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (tokenList instanceof SnapshotTokenList) {
            tokenHierarchy = ((SnapshotTokenList)tokenList).snapshot().tokenHierarchy();
            sb.append(tokenList).append('\n');
        } else {
            tokenHierarchy = null;
        }
        int tokenCount = Math.min(tokenList.tokenCountCurrent(), endIndex);
        int digitCount = ArrayUtilities.digitCount((int)tokenCount);
        for (int i = Math.max(startIndex, 0); i < tokenCount; ++i) {
            sb.append(i == currentIndex ? (char)'*' : ' ');
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            LexerUtilsConstants.appendTokenInfo(sb, tokenList.tokenOrEmbeddingContainer(i), tokenHierarchy);
            LexerUtilsConstants.appendLAState(sb, tokenList, i);
            sb.append('\n');
        }
        return sb;
    }

    public static boolean statesEqual(Object state1, Object state2) {
        return state1 == null && state2 == null || state1 != null && state1.equals(state2);
    }

    public static String idToString(TokenId id) {
        return id.name() + '[' + id.ordinal() + ']';
    }

    public static <T extends TokenId, ET extends TokenId> TokenList<ET> embeddedTokenList(TokenList<T> tokenList, int tokenIndex, Language<ET> embeddedLanguage) {
        TokenList<ET> embeddedTokenList = EmbeddingContainer.getEmbedding(tokenList, tokenIndex, embeddedLanguage);
        if (embeddedTokenList != null) {
            TokenList<T> tl = tokenList;
            if (tokenList.getClass() == SubSequenceTokenList.class) {
                tl = ((SubSequenceTokenList)tokenList).delegate();
            }
            if (tl.getClass() == FilterSnapshotTokenList.class) {
                embeddedTokenList = new FilterSnapshotTokenList<ET>(embeddedTokenList, ((FilterSnapshotTokenList)tl).tokenOffsetDiff());
            } else if (tl.getClass() == SnapshotTokenList.class) {
                AbstractToken<T> token = LexerUtilsConstants.token(tokenList, tokenIndex);
                embeddedTokenList = new FilterSnapshotTokenList<ET>(embeddedTokenList, tokenList.tokenOffset(tokenIndex) - ((Token)token).offset(null));
            }
            return embeddedTokenList;
        }
        return null;
    }

    public static void appendTokenInfo(StringBuilder sb, Object tokenOrEmbeddingContainer, TokenHierarchy<?> tokenHierarchy) {
        if (tokenOrEmbeddingContainer == null) {
            sb.append("<NULL-TOKEN>");
        } else if (tokenOrEmbeddingContainer.getClass() == EmbeddingContainer.class) {
            EmbeddingContainer ec = (EmbeddingContainer)tokenOrEmbeddingContainer;
            sb.append("E[");
            boolean first = true;
            for (EmbeddedTokenList<TokenId> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                sb.append('\"').append(etl.languagePath().mimePath()).append('\"');
                if (first) {
                    first = false;
                    continue;
                }
                sb.append(',');
            }
            sb.append("] ");
            LexerUtilsConstants.appendIdentityHashCode(sb, ec);
            sb.append(": ");
            LexerUtilsConstants.appendTokenInfo(sb, ec.token(), tokenHierarchy);
        } else {
            Token token = (Token)tokenOrEmbeddingContainer;
            sb.append(((AbstractToken)token).dumpInfo(tokenHierarchy));
            sb.append(' ');
            LexerUtilsConstants.appendIdentityHashCode(sb, token);
        }
    }

    public static void appendIdentityHashCode(StringBuilder sb, Object o) {
        sb.append("IHC(");
        sb.append(System.identityHashCode(o));
        sb.append(')');
    }

    public static void appendLAState(StringBuilder sb, TokenList<? extends TokenId> tokenList, int index) {
        Object state;
        int lookahead = tokenList.lookahead(index);
        if (lookahead > 0) {
            sb.append(", la=");
            sb.append(lookahead);
        }
        if ((state = tokenList.state(index)) != null) {
            sb.append(", st=");
            sb.append(state);
        }
    }

    private LexerUtilsConstants() {
    }
}

