/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubSequenceTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenList<T> tokenList;
    private AbstractToken<T> lastToken;
    private int lastTokenIndex;
    private int lastTokenOffset;
    private final int limitStartOffset;
    private final int limitEndOffset;
    private int limitStartIndex;
    private int limitEndIndex;

    public static <T extends TokenId> SubSequenceTokenList<T> create(TokenList<T> tokenList, int limitStartOffset, int limitEndOffset) {
        return new SubSequenceTokenList<T>(tokenList, limitStartOffset, limitEndOffset);
    }

    public SubSequenceTokenList(TokenList<T> tokenList, int limitStartOffset, int limitEndOffset) {
        this.tokenList = tokenList;
        this.limitStartOffset = limitStartOffset;
        this.limitEndOffset = limitEndOffset;
        if (limitStartOffset > 0) {
            int diff = this.move(limitStartOffset);
            if (diff != Integer.MAX_VALUE) {
                if (diff >= this.lastToken.length()) {
                    ++this.lastTokenIndex;
                    Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainer(this.lastTokenIndex);
                    if (tokenOrEmbeddingContainer != null && (this.lastTokenOffset = tokenList.tokenOffset(this.lastTokenIndex)) < limitEndOffset) {
                        this.lastToken = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                        this.limitStartIndex = this.lastTokenIndex;
                        this.limitEndIndex = Integer.MAX_VALUE;
                    }
                } else if (limitEndOffset == Integer.MAX_VALUE || this.lastTokenOffset < limitEndOffset) {
                    this.limitStartIndex = this.lastTokenIndex;
                    this.limitEndIndex = Integer.MAX_VALUE;
                }
            }
        } else {
            Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainer(0);
            if (tokenOrEmbeddingContainer != null && (this.lastTokenOffset = tokenList.tokenOffset(0)) < limitEndOffset) {
                this.lastToken = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                this.limitEndIndex = Integer.MAX_VALUE;
            }
        }
    }

    public TokenList<T> delegate() {
        return this.tokenList;
    }

    public int limitStartOffset() {
        return this.limitStartOffset;
    }

    public int limitEndOffset() {
        return this.limitEndOffset;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int index) {
        if (this.limitStartIndex == -1) {
            return null;
        }
        index += this.limitStartIndex;
        if (this.limitEndIndex == Integer.MAX_VALUE) {
            int tokenOffset;
            switch (index - this.lastTokenIndex) {
                case -1: {
                    if (index < this.limitStartIndex) {
                        return null;
                    }
                    Object tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(index);
                    AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                    this.lastTokenIndex = index;
                    this.lastTokenOffset = this.tokenList.isContinuous() || this.lastToken.isFlyweight() ? (this.lastTokenOffset -= token.length()) : this.tokenList.tokenOffset(index);
                    this.lastToken = token;
                    return tokenOrEmbeddingContainer;
                }
                case 0: {
                    return this.lastToken;
                }
                case 1: {
                    Object tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(index);
                    if (tokenOrEmbeddingContainer != null) {
                        AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                        int tokenOffset2 = this.tokenList.isContinuous() || token.isFlyweight() ? this.lastTokenOffset + this.lastToken.length() : this.tokenList.tokenOffset(index);
                        if (tokenOffset2 < this.limitEndOffset) {
                            this.lastToken = token;
                            this.lastTokenIndex = index;
                            this.lastTokenOffset = tokenOffset2;
                            return tokenOrEmbeddingContainer;
                        }
                    }
                    this.limitEndIndex = index;
                    return null;
                }
            }
            Object tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(index);
            if (tokenOrEmbeddingContainer != null && (tokenOffset = this.tokenList.tokenOffset(index)) < this.limitEndOffset) {
                this.lastToken = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                this.lastTokenIndex = index;
                this.lastTokenOffset = tokenOffset;
                return tokenOrEmbeddingContainer;
            }
            this.tokenCount();
            return null;
        }
        return index < this.limitEndIndex ? this.tokenList.tokenOrEmbeddingContainer(index) : null;
    }

    @Override
    public int tokenOffset(int index) {
        if ((index += this.limitStartIndex) == this.lastTokenIndex) {
            return this.lastTokenOffset;
        }
        return this.tokenList.tokenOffset(index);
    }

    @Override
    public int tokenCount() {
        if (this.limitEndIndex == Integer.MAX_VALUE) {
            int diff = this.move(this.limitEndOffset - 1);
            assert (diff != Integer.MAX_VALUE);
            this.limitEndIndex = this.lastTokenIndex + 1;
        }
        return this.limitEndIndex - this.limitStartIndex;
    }

    @Override
    public int tokenCountCurrent() {
        if (this.limitEndIndex != Integer.MAX_VALUE) {
            return this.tokenCount();
        }
        int tcc = this.tokenList.tokenCountCurrent();
        if (this.tokenOffset(tcc - 1 - this.limitStartIndex) >= this.limitEndOffset) {
            return this.tokenCount();
        }
        return tcc - this.limitStartIndex;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        return this.tokenList.replaceFlyToken(index + this.limitStartIndex, flyToken, offset);
    }

    @Override
    public int modCount() {
        return this.tokenList.modCount();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer<T> embeddingContainer) {
        this.tokenList.wrapToken(this.limitStartIndex + index, embeddingContainer);
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this.tokenList.root();
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public int lookahead(int index) {
        return this.tokenList.lookahead(index);
    }

    @Override
    public Object state(int index) {
        return this.tokenList.state(index);
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return this.limitStartOffset;
    }

    @Override
    public int endOffset() {
        int cntM1 = this.tokenCount() - 1;
        if (cntM1 >= 0) {
            return this.tokenOffset(cntM1) + this.token(cntM1).length();
        }
        return this.limitStartOffset;
    }

    private AbstractToken<T> token(int index) {
        return LexerUtilsConstants.token(this.tokenList, index);
    }

    private int move(int offset) {
        int tokenCount = this.tokenList.tokenCountCurrent();
        if (tokenCount == 0) {
            if (this.tokenList.tokenOrEmbeddingContainer(0) == null) {
                return Integer.MAX_VALUE;
            }
            tokenCount = this.tokenList.tokenCountCurrent();
        }
        this.lastTokenOffset = this.tokenList.tokenOffset(tokenCount - 1);
        if (offset > this.lastTokenOffset) {
            Object tokenOrEmbeddingContainer;
            this.lastToken = this.token(tokenCount - 1);
            int tokenLength = this.lastToken.length();
            while (offset >= this.lastTokenOffset + tokenLength && (tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(tokenCount)) != null) {
                this.lastToken = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                this.lastTokenOffset = this.lastToken.isFlyweight() ? (this.lastTokenOffset += tokenLength) : this.tokenList.tokenOffset(tokenCount);
                tokenLength = this.lastToken.length();
                ++tokenCount;
            }
            this.lastTokenIndex = tokenCount - 1;
            return offset - this.lastTokenOffset;
        }
        int low = 0;
        int high = tokenCount - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midStartOffset = this.tokenList.tokenOffset(mid);
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            this.lastToken = this.token(mid);
            this.lastTokenIndex = mid;
            this.lastTokenOffset = midStartOffset;
            return 0;
        }
        if (high < 0) {
            high = 0;
        }
        this.lastToken = this.token(high);
        this.lastTokenOffset = this.tokenList.tokenOffset(high);
        this.lastTokenIndex = high;
        return offset - this.lastTokenOffset;
    }
}

