/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.batch.TextTokenList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListUpdater;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyOperation<I, T extends TokenId> {
    private static final Logger LOG = Logger.getLogger(TokenHierarchyOperation.class.getName());
    private TokenHierarchy<I> tokenHierarchy;
    private MutableTextInput<I> mutableTextInput;
    private TokenList<T> tokenList;
    private boolean active = true;
    private TokenHierarchyOperation<I, T> liveTokenHierarchyOperation;
    private List<SnapshotRef> snapshotRefs;
    private EventListenerList listenerList;
    private boolean snapshotReleased;
    private Set<LanguagePath> languagePaths;
    private Set<Language<? extends TokenId>> exploredLanguages;
    private Map<LanguagePath, TokenListList> tokenListListMap;

    public TokenHierarchyOperation(Reader inputReader, Language<T> language, Set<T> skipTokenIds, InputAttributes inputAttributes) {
        this.tokenList = new CopyTextTokenList<T>(this, inputReader, language, skipTokenIds, inputAttributes);
        this.init();
    }

    public TokenHierarchyOperation(CharSequence inputText, boolean copyInputText, Language<T> language, Set<T> skipTokenIds, InputAttributes inputAttributes) {
        this.tokenList = copyInputText ? new CopyTextTokenList<T>(this, inputText, language, skipTokenIds, inputAttributes) : new TextTokenList<T>(this, inputText, language, skipTokenIds, inputAttributes);
        this.init();
    }

    public TokenHierarchyOperation(MutableTextInput<I> mutableTextInput, Language<T> language) {
        this.mutableTextInput = mutableTextInput;
        this.tokenList = new IncTokenList(this, mutableTextInput);
        this.init();
    }

    public TokenHierarchyOperation(TokenHierarchyOperation<I, T> liveTokenHierarchy) {
        this.liveTokenHierarchyOperation = liveTokenHierarchy;
        this.tokenList = new SnapshotTokenList(this);
        this.init();
    }

    private void init() {
        assert (this.tokenHierarchy == null);
        this.tokenHierarchy = LexerApiPackageAccessor.get().createTokenHierarchy(this);
        this.listenerList = new EventListenerList();
        if (this.isMutable()) {
            this.snapshotRefs = new ArrayList<SnapshotRef>(1);
        }
    }

    public TokenHierarchy<I> tokenHierarchy() {
        return this.tokenHierarchy;
    }

    public TokenList<T> tokenList() {
        return this.tokenList;
    }

    public TokenList<T> checkedTokenList() {
        this.checkSnapshotNotReleased();
        return this.tokenList();
    }

    public boolean isMutable() {
        return this.mutableTextInput != null;
    }

    public MutableTextInput mutableTextInput() {
        return this.mutableTextInput;
    }

    public I mutableInputSource() {
        return this.isMutable() ? (I)LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput) : null;
    }

    public void setActive(boolean active) {
        assert (this.isMutable());
        if (this.active != active) {
            this.active = active;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized TokenListList tokenListList(LanguagePath languagePath) {
        TokenListList tll;
        if (this.tokenListListMap == null) {
            this.tokenListListMap = new HashMap<LanguagePath, TokenListList>();
        }
        if ((tll = this.tokenListListMap.get(languagePath)) == null) {
            tll = new TokenListList(this, languagePath);
            this.tokenListListMap.put(languagePath, tll);
        }
        return tll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        if (this.isSnapshot()) {
            return;
        }
        if (this.active) {
            IncTokenList incTokenList = (IncTokenList)this.tokenList;
            incTokenList.incrementModCount();
            TokenListChange change = new TokenListChange(incTokenList);
            CharSequence text = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
            int endOffset = incTokenList.existingTokensEndOffset();
            TokenHierarchyEventInfo eventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.REBUILD, 0, 0, text, 0);
            change.setIndex(0);
            change.setOffset(0);
            change.setAddedEndOffset(0);
            incTokenList.replaceTokens(eventInfo, change, incTokenList.tokenCountCurrent());
            incTokenList.restartLexing();
            incTokenList.incrementModCount();
            List<SnapshotRef> list = this.snapshotRefs;
            synchronized (list) {
                for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                    TokenHierarchyOperation op = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                    if (op == null) continue;
                    ((SnapshotTokenList)op.tokenList()).update(eventInfo, change);
                }
            }
            eventInfo.setTokenChangeInfo(change.tokenChangeInfo());
            eventInfo.setAffectedStartOffset(0);
            eventInfo.setAffectedEndOffset(text.length());
            this.updateCaches();
            this.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent(eventInfo));
        }
    }

    public void fireTokenHierarchyChanged(TokenHierarchyEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        int listenersLength = listeners.length;
        for (int i = 1; i < listenersLength; i += 2) {
            ((TokenHierarchyListener)listeners[i]).tokenHierarchyChanged(evt);
        }
    }

    public void addTokenHierarchyListener(TokenHierarchyListener listener) {
        this.listenerList.add(TokenHierarchyListener.class, listener);
    }

    public void removeTokenHierarchyListener(TokenHierarchyListener listener) {
        this.listenerList.remove(TokenHierarchyListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textModified(int offset, int removedLength, CharSequence removedText, int insertedLength) {
        TokenHierarchyEventInfo eventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.MODIFICATION, offset, removedLength, removedText, insertedLength);
        if (this.active) {
            IncTokenList incTokenList = (IncTokenList)this.tokenList;
            incTokenList.incrementModCount();
            TokenListChange change = new TokenListChange(incTokenList);
            TokenListUpdater.update(incTokenList, eventInfo, change);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("<<<<<<<<<<<<<<<<<< LEXER CHANGE START ------------------\n");
                LOG.fine("ROOT CHANGE: " + change.toString(0) + "\n");
            }
            if (!incTokenList.isFullyLexed()) {
                incTokenList.refreshLexerInputOperation();
            }
            List<SnapshotRef> list = this.snapshotRefs;
            synchronized (list) {
                for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                    TokenHierarchyOperation op = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                    if (op == null) continue;
                    ((SnapshotTokenList)op.tokenList()).update(eventInfo, change);
                }
            }
            eventInfo.setTokenChangeInfo(change.tokenChangeInfo());
            if (change.isBoundsChange()) {
                eventInfo.setAffectedStartOffset(eventInfo.modificationOffset());
                eventInfo.setAffectedEndOffset(eventInfo.modificationOffset() + Math.max(0, eventInfo.insertedLength() - eventInfo.removedLength()));
                this.addNestedChanges(eventInfo, change, 1);
            } else {
                eventInfo.setAffectedStartOffset(change.offset());
                eventInfo.setAffectedEndOffset(change.addedEndOffset());
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EVENT: " + eventInfo + "\n");
                String extraMsg = "";
                if (LOG.isLoggable(Level.FINER)) {
                    String error = this.checkConsistency();
                    if (error != null) {
                        LOG.finer("!!!CONSISTENCY-ERROR!!!: " + error + "\n");
                    } else {
                        extraMsg = "(TokenHierarchy Check OK) ";
                    }
                }
                LOG.fine(">>>>>>>>>>>>>>>>>> LEXER CHANGE END " + extraMsg + "------------------\n");
            }
            this.updateCaches();
            this.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent(eventInfo));
        }
    }

    private void updateCaches() {
        if (this.tokenListListMap != null) {
            this.tokenListListMap.clear();
        }
    }

    private <TX extends TokenId> void addNestedChanges(TokenHierarchyEventInfo eventInfo, TokenListChange<TX> change, int level) {
        EmbeddedTokenList<TokenId> etl = EmbeddingContainer.getEmbeddingIfExists(change.tokenChangeInfo().removedTokenList().tokenOrEmbeddingContainer(0));
        if (etl != null) {
            EmbeddingContainer newEC = new EmbeddingContainer((AbstractToken)change.addedTokensOrBranches().get(0));
            newEC.setFirstEmbeddedTokenList(etl);
            change.tokenList().wrapToken(change.index(), newEC);
            do {
                etl.setEmbeddingContainer(newEC);
                TokenListChange<TokenId> nestedChange = new TokenListChange<TokenId>(etl);
                EmbeddedTokenList<TokenId> etlT = etl;
                TokenListUpdater.update(etlT, eventInfo, nestedChange);
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(level << 2));
                    sb.append("NESTED CHANGE at level=");
                    sb.append(level);
                    sb.append(": ");
                    sb.append(nestedChange.toString(level << 2));
                    sb.append('\n');
                    LOG.fine(sb.toString());
                }
                change.tokenChangeInfo().addEmbeddedChange(nestedChange.tokenChangeInfo());
                if (nestedChange.isBoundsChange()) {
                    this.addNestedChanges(eventInfo, nestedChange, level + 1);
                    continue;
                }
                eventInfo.setMinAffectedStartOffset(nestedChange.offset());
                eventInfo.setMaxAffectedEndOffset(nestedChange.addedEndOffset());
            } while ((etl = etl.nextEmbeddedTokenList()) != null);
        }
    }

    private Language<T> language() {
        Language<? extends TokenId> l;
        TokenList<T> tl = this.tokenList();
        if (tl != null) {
            l = this.tokenList.languagePath().topLanguage();
        } else {
            assert (this.mutableTextInput != null);
            l = LexerSpiPackageAccessor.get().language(this.mutableTextInput);
        }
        Language<? extends TokenId> language = l;
        return language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set<LanguagePath> lps;
        TokenHierarchyOperation tokenHierarchyOperation = this;
        synchronized (tokenHierarchyOperation) {
            lps = this.languagePaths;
        }
        if (lps == null) {
            LanguageOperation<T> langOp = LexerUtilsConstants.languageOperation(this.language());
            Set clps = (Set)((HashSet)langOp.languagePaths()).clone();
            Set cel = (Set)((HashSet)langOp.exploredLanguages()).clone();
            TokenHierarchyOperation tokenHierarchyOperation2 = this;
            synchronized (tokenHierarchyOperation2) {
                this.languagePaths = lps;
                this.exploredLanguages = cel;
            }
        }
        return lps;
    }

    public void addLanguagePath(LanguagePath lp, Language language) {
        Set<LanguagePath> elps = this.languagePaths();
        if (!elps.contains(lp)) {
            HashSet<LanguagePath> lps = new HashSet<LanguagePath>();
            LanguageOperation.findLanguagePaths(elps, lps, this.exploredLanguages, lp, null);
            elps.addAll(lps);
        }
    }

    public boolean isSnapshot() {
        return this.liveTokenHierarchyOperation != null;
    }

    public TokenHierarchy<I> snapshotOf() {
        return this.isSnapshot() ? this.liveTokenHierarchyOperation.tokenHierarchy() : null;
    }

    private void checkIsSnapshot() {
        if (!this.isSnapshot()) {
            throw new IllegalStateException("Not a snapshot");
        }
    }

    private void checkSnapshotNotReleased() {
        if (this.snapshotReleased) {
            throw new IllegalStateException("Snapshot already released");
        }
    }

    public TokenHierarchy<I> createSnapshot() {
        if (this.isMutable()) {
            TokenHierarchyOperation<I, T> snapshot = new TokenHierarchyOperation<I, T>(this);
            this.snapshotRefs.add(new SnapshotRef(snapshot));
            return snapshot.tokenHierarchy();
        }
        return null;
    }

    public void snapshotRelease() {
        this.checkIsSnapshot();
        this.checkSnapshotNotReleased();
        this.snapshotReleased = true;
        if (this.liveTokenHierarchyOperation != null) {
            this.liveTokenHierarchyOperation.removeSnapshot(this);
        }
    }

    public boolean isSnapshotReleased() {
        return this.snapshotReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSnapshot(SnapshotRef snapshotRef) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            this.snapshotRefs.remove(snapshotRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSnapshot(TokenHierarchyOperation<I, T> snapshot) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                Reference ref = this.snapshotRefs.get(i);
                if (ref.get() != snapshot) continue;
                this.snapshotRefs.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int snapshotCount() {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            return this.snapshotRefs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canModifyToken(int index, AbstractToken token) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            for (int i = this.snapshotCount() - 1; i >= 0; --i) {
                TokenHierarchyOperation op = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                if (op == null || !((SnapshotTokenList)op.tokenList()).canModifyToken(index, token)) continue;
                return false;
            }
        }
        return true;
    }

    public TokenHierarchyOperation<I, T> liveTokenHierarchyOperation() {
        return this.liveTokenHierarchyOperation;
    }

    public <TT extends TokenId> int tokenOffset(AbstractToken<TT> token, TokenList<TT> tokenList, int rawOffset) {
        if (this.tokenList.getClass() == SnapshotTokenList.class) {
            if (tokenList != null) {
                SnapshotTokenList tlUC = (SnapshotTokenList)this.tokenList;
                return tlUC.tokenOffset(token, tokenList, rawOffset);
            }
            return rawOffset;
        }
        return tokenList != null ? tokenList.childTokenOffset(rawOffset) : rawOffset;
    }

    public int tokenShiftStartOffset() {
        return this.isSnapshot() ? ((SnapshotTokenList)this.tokenList).tokenShiftStartOffset() : -1;
    }

    public int tokenShiftEndOffset() {
        return this.isSnapshot() ? ((SnapshotTokenList)this.tokenList).tokenShiftEndOffset() : -1;
    }

    public String checkConsistency() {
        return this.checkConsistencyTokenList(this.checkedTokenList(), ArrayUtilities.emptyIntArray(), 0);
    }

    private String checkConsistencyTokenList(TokenList<? extends TokenId> tokenList, int[] parentIndexes, int firstTokenOffset) {
        int tokenCountCurrent = tokenList.tokenCountCurrent();
        int[] indexes = ArrayUtilities.intArray((int[])parentIndexes, (int)(parentIndexes.length + 1));
        boolean continuous = tokenList.isContinuous();
        int lastOffset = firstTokenOffset;
        for (int i = 0; i < tokenCountCurrent; ++i) {
            int offset;
            Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainer(i);
            if (tokenOrEmbeddingContainer == null) {
                return this.dumpContext("Null token", tokenList, i, parentIndexes);
            }
            AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
            int n = offset = ((Token)token).isFlyweight() ? lastOffset : ((Token)token).offset(null);
            if (offset < 0) {
                return this.dumpContext("Token offset=" + offset + " < 0", tokenList, i, parentIndexes);
            }
            if (offset < lastOffset) {
                return this.dumpContext("Token offset=" + offset + " < lastOffset=" + lastOffset, tokenList, i, parentIndexes);
            }
            if (offset > lastOffset && continuous) {
                return this.dumpContext("Gap between tokens; offset=" + offset + ", lastOffset=" + lastOffset, tokenList, i, parentIndexes);
            }
            lastOffset = offset + ((Token)token).length();
            if (tokenOrEmbeddingContainer.getClass() != EmbeddingContainer.class) continue;
            EmbeddingContainer ec = (EmbeddingContainer)tokenOrEmbeddingContainer;
            for (EmbeddedTokenList<TokenId> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                String error = this.checkConsistencyTokenList(etl, indexes, offset + etl.embedding().startSkipLength());
                if (error == null) continue;
                return error;
            }
        }
        return null;
    }

    private String dumpContext(String msg, TokenList<?> tokenList, int index, int[] parentIndexes) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append(" at index=");
        sb.append(index);
        sb.append(" of tokens of language ");
        sb.append(tokenList.languagePath().innerLanguage().mimeType());
        sb.append('\n');
        LexerUtilsConstants.appendTokenList(sb, tokenList, index, index - 2, index + 3);
        sb.append("\nParents:\n");
        sb.append(this.tracePath(parentIndexes, tokenList.languagePath()));
        return sb.toString();
    }

    private String tracePath(int[] indexes, LanguagePath languagePath) {
        StringBuilder sb = new StringBuilder();
        TokenList<T> tokenList = this.checkedTokenList();
        for (int i = 0; i < indexes.length; ++i) {
            LexerUtilsConstants.appendTokenInfo(sb, tokenList.tokenOrEmbeddingContainer(i), this.tokenHierarchy());
            tokenList = EmbeddingContainer.getEmbedding(tokenList, indexes[i], languagePath.language(i));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SnapshotRef
    extends WeakReference<TokenHierarchyOperation<I, T>>
    implements Runnable {
        SnapshotRef(TokenHierarchyOperation<I, T> snapshot) {
            super(snapshot, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            if (TokenHierarchyOperation.this.liveTokenHierarchyOperation != null) {
                TokenHierarchyOperation.this.liveTokenHierarchyOperation.removeSnapshot(this);
            }
        }
    }
}

